/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathIds;
import io.crnk.core.engine.internal.dispatcher.path.RelationshipsPath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.RequestBodyException;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.Collections;

public abstract class RelationshipsResourceUpsert
extends ResourceIncludeField {
    RelationshipsResourceUpsert(ResourceRegistry resourceRegistry, TypeParser typeParser, DocumentMapper documentMapper) {
        super(resourceRegistry, typeParser, documentMapper);
    }

    protected abstract HttpMethod method();

    protected abstract void processToManyRelationship(Object var1, ResourceInformation var2, ResourceField var3, Iterable<ResourceIdentifier> var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    protected abstract void processToOneRelationship(Object var1, ResourceInformation var2, ResourceField var3, ResourceIdentifier var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    @Override
    public final boolean isAcceptable(JsonPath jsonPath, String requestType) {
        PreconditionUtil.assertNotNull("jsonPath cannot be null", jsonPath);
        return !jsonPath.isCollection() && RelationshipsPath.class.equals(jsonPath.getClass()) && this.method().name().equals(requestType);
    }

    @Override
    public final Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        String resourceName = jsonPath.getResourceType();
        PathIds resourceIds = jsonPath.getIds();
        RegistryEntry registryEntry = this.getRegistryEntry(resourceName);
        this.assertRequestDocument(requestBody, HttpMethod.POST, resourceName);
        Serializable castedResourceId = this.getResourceId(resourceIds, registryEntry);
        ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(jsonPath.getElementName());
        RelationshipsResourceUpsert.verifyFieldNotNull(relationshipField, jsonPath.getElementName());
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository(parameterProvider);
        Object resource = resourceRepository.findOne(castedResourceId, queryAdapter).getEntity();
        ResourceInformation targetInformation = this.getRegistryEntry(relationshipField.getOppositeResourceType()).getResourceInformation();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = registryEntry.getRelationshipRepositoryForType(relationshipField.getOppositeResourceType(), parameterProvider);
        if (Iterable.class.isAssignableFrom(relationshipField.getType())) {
            Iterable dataBodies = requestBody.isMultiple() ? requestBody.getData().get() : Collections.singletonList(requestBody.getData().get());
            this.processToManyRelationship(resource, targetInformation, relationshipField, dataBodies, queryAdapter, relationshipRepositoryForClass);
        } else {
            if (requestBody.isMultiple()) {
                throw new RequestBodyException(HttpMethod.POST, resourceName, "Multiple data in body");
            }
            ResourceIdentifier dataBody = (ResourceIdentifier)requestBody.getData().get();
            this.processToOneRelationship(resource, targetInformation, relationshipField, dataBody, queryAdapter, relationshipRepositoryForClass);
        }
        return new Response(new Document(), 204);
    }

    private Serializable getResourceId(PathIds resourceIds, RegistryEntry registryEntry) {
        String resourceId = resourceIds.getIds().get(0);
        Class<?> idClass = registryEntry.getResourceInformation().getIdField().getType();
        return this.typeParser.parse(resourceId, idClass);
    }
}

