/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module;

import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.RepositoryFilter;
import io.crnk.core.engine.filter.ResourceFilter;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.information.repository.RepositoryInformationProvider;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.security.SecurityProvider;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleExtension;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleModule
implements Module {
    private List<ResourceInformationProvider> resourceInformationProviders = new ArrayList<ResourceInformationProvider>();
    private List<HttpRequestProcessor> httpRequestProcessors = new ArrayList<HttpRequestProcessor>();
    private List<RepositoryInformationProvider> repositoryInformationProviders = new ArrayList<RepositoryInformationProvider>();
    private List<DocumentFilter> documentFilters = new ArrayList<DocumentFilter>();
    private List<RepositoryFilter> repositoryFilters = new ArrayList<RepositoryFilter>();
    private List<ResourceFilter> resourceFilters = new ArrayList<ResourceFilter>();
    private List<RepositoryDecoratorFactory> repositoryDecoratorFactories = new ArrayList<RepositoryDecoratorFactory>();
    private List<SecurityProvider> securityProviders = new ArrayList<SecurityProvider>();
    private List<ResourceLookup> resourceLookups = new ArrayList<ResourceLookup>();
    private List<com.fasterxml.jackson.databind.Module> jacksonModules = new ArrayList<com.fasterxml.jackson.databind.Module>();
    private List<Object> repositories = new ArrayList<Object>();
    private List<ExceptionMapperLookup> exceptionMapperLookups = new ArrayList<ExceptionMapperLookup>();
    private List<RegistryEntry> registryEntries = new ArrayList<RegistryEntry>();
    private List<ModuleExtension> extensions = new ArrayList<ModuleExtension>();
    private String moduleName;
    private Module.ModuleContext context;
    private Map<String, ResourceRegistryPart> registryParts = new HashMap<String, ResourceRegistryPart>();

    public SimpleModule(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void setupModule(Module.ModuleContext context) {
        this.context = context;
        for (ResourceInformationProvider resourceInformationProvider : this.resourceInformationProviders) {
            context.addResourceInformationBuilder(resourceInformationProvider);
        }
        for (RepositoryInformationProvider repositoryInformationProvider : this.repositoryInformationProviders) {
            context.addRepositoryInformationBuilder(repositoryInformationProvider);
        }
        for (ResourceLookup resourceLookup : this.resourceLookups) {
            context.addResourceLookup(resourceLookup);
        }
        for (DocumentFilter documentFilter : this.documentFilters) {
            context.addFilter(documentFilter);
        }
        for (RepositoryFilter repositoryFilter : this.repositoryFilters) {
            context.addRepositoryFilter(repositoryFilter);
        }
        for (ResourceFilter resourceFilter : this.resourceFilters) {
            context.addResourceFilter(resourceFilter);
        }
        for (RepositoryDecoratorFactory repositoryDecoratorFactory : this.repositoryDecoratorFactories) {
            context.addRepositoryDecoratorFactory(repositoryDecoratorFactory);
        }
        for (com.fasterxml.jackson.databind.Module module : this.jacksonModules) {
            context.addJacksonModule(module);
        }
        for (Object object : this.repositories) {
            context.addRepository(object);
        }
        for (ExceptionMapperLookup exceptionMapperLookup : this.exceptionMapperLookups) {
            context.addExceptionMapperLookup(exceptionMapperLookup);
        }
        for (HttpRequestProcessor httpRequestProcessor : this.httpRequestProcessors) {
            context.addHttpRequestProcessor(httpRequestProcessor);
        }
        for (ModuleExtension moduleExtension : this.extensions) {
            context.addExtension(moduleExtension);
        }
    }

    private void checkInitialized() {
        if (this.context != null) {
            throw new IllegalStateException("module cannot be changed addModule was called");
        }
    }

    public void addResourceInformationProvider(ResourceInformationProvider resourceInformationProvider) {
        this.checkInitialized();
        this.resourceInformationProviders.add(resourceInformationProvider);
    }

    public void addRepositoryInformationBuilder(RepositoryInformationProvider repositoryInformationProvider) {
        this.checkInitialized();
        this.repositoryInformationProviders.add(repositoryInformationProvider);
    }

    public void addExceptionMapperLookup(ExceptionMapperLookup exceptionMapperLookup) {
        this.checkInitialized();
        this.exceptionMapperLookups.add(exceptionMapperLookup);
    }

    public void addExceptionMapper(JsonApiExceptionMapper exceptionMapper) {
        this.checkInitialized();
        CollectionExceptionMapperLookup exceptionMapperLookup = new CollectionExceptionMapperLookup(exceptionMapper);
        this.exceptionMapperLookups.add(exceptionMapperLookup);
    }

    protected List<ResourceInformationProvider> getResourceInformationProviders() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.resourceInformationProviders);
    }

    protected List<RepositoryInformationProvider> getRepositoryInformationProviders() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.repositoryInformationProviders);
    }

    public Map<String, ResourceRegistryPart> getRegistryParts() {
        return Collections.unmodifiableMap(this.registryParts);
    }

    public void addExtension(ModuleExtension extension) {
        this.checkInitialized();
        this.extensions.add(extension);
    }

    public void addFilter(DocumentFilter filter) {
        this.checkInitialized();
        this.documentFilters.add(filter);
    }

    public void addRepositoryFilter(RepositoryFilter filter) {
        this.checkInitialized();
        this.repositoryFilters.add(filter);
    }

    public void addResourceFilter(ResourceFilter filter) {
        this.checkInitialized();
        this.resourceFilters.add(filter);
    }

    public void addRepositoryDecoratorFactory(RepositoryDecoratorFactory decorator) {
        this.checkInitialized();
        this.repositoryDecoratorFactories.add(decorator);
    }

    protected List<DocumentFilter> getFilters() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.documentFilters);
    }

    protected List<RepositoryFilter> getRepositoryFilters() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.repositoryFilters);
    }

    protected List<ResourceFilter> getResourceFilters() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.resourceFilters);
    }

    protected List<ModuleExtension> getExtensions() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.extensions);
    }

    protected List<RepositoryDecoratorFactory> getRepositoryDecoratorFactories() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.repositoryDecoratorFactories);
    }

    public void addSecurityProvider(SecurityProvider securityProvider) {
        this.checkInitialized();
        this.securityProviders.add(securityProvider);
    }

    public void addJacksonModule(com.fasterxml.jackson.databind.Module module) {
        this.checkInitialized();
        this.jacksonModules.add(module);
    }

    protected List<com.fasterxml.jackson.databind.Module> getJacksonModules() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.jacksonModules);
    }

    public void addResourceLookup(ResourceLookup resourceLookup) {
        this.checkInitialized();
        this.resourceLookups.add(resourceLookup);
    }

    protected List<ResourceLookup> getResourceLookups() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.resourceLookups);
    }

    public void addRepository(Object repository) {
        this.checkInitialized();
        this.repositories.add(repository);
    }

    @Deprecated
    public void addRepository(Class<?> resourceClass, Object repository) {
        this.checkInitialized();
        this.repositories.add(repository);
    }

    @Deprecated
    public void addRepository(Class<?> sourceType, Class<?> targetType, Object repository) {
        this.checkInitialized();
        this.repositories.add(repository);
    }

    public List<Object> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public List<ExceptionMapperLookup> getExceptionMapperLookups() {
        return Collections.unmodifiableList(this.exceptionMapperLookups);
    }

    public List<SecurityProvider> getSecurityProviders() {
        return Collections.unmodifiableList(this.securityProviders);
    }

    public void addHttpRequestProcessor(HttpRequestProcessor httpRequestProcessor) {
        this.httpRequestProcessors.add(httpRequestProcessor);
    }

    public List<HttpRequestProcessor> getHttpRequestProcessors() {
        return Collections.unmodifiableList(this.httpRequestProcessors);
    }

    public void addRegistryPart(String prefix, ResourceRegistryPart part) {
        if (this.registryParts.containsKey(prefix)) {
            throw new IllegalStateException("part with prefix " + prefix + " is already registered");
        }
        this.registryParts.put(prefix, part);
    }

    public List<RegistryEntry> getRegistryEntries() {
        return Collections.unmodifiableList(this.registryEntries);
    }

    public void addRegistryEntry(RegistryEntry entry) {
        this.registryEntries.add(entry);
    }

    private static class CollectionExceptionMapperLookup
    implements ExceptionMapperLookup {
        private Set<JsonApiExceptionMapper> set;

        private CollectionExceptionMapperLookup(Set<JsonApiExceptionMapper> set) {
            this.set = set;
        }

        public CollectionExceptionMapperLookup(JsonApiExceptionMapper exceptionMapper) {
            this(new HashSet<JsonApiExceptionMapper>(Arrays.asList(exceptionMapper)));
        }

        @Override
        public Set<JsonApiExceptionMapper> getExceptionMappers() {
            return this.set;
        }
    }
}

