/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourceUpsert;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.ResourceRegistry;
import java.io.Serializable;
import java.util.LinkedList;

public class RelationshipsResourcePatch
extends RelationshipsResourceUpsert {
    public RelationshipsResourcePatch(ResourceRegistry resourceRegistry, TypeParser typeParser) {
        super(resourceRegistry, typeParser, null);
    }

    @Override
    public HttpMethod method() {
        return HttpMethod.PATCH;
    }

    @Override
    public void processToManyRelationship(Object resource, ResourceInformation targetResourceInformation, ResourceField relationshipField, Iterable<ResourceIdentifier> dataBodies, QueryAdapter queryAdapter, RelationshipRepositoryAdapter relationshipRepositoryForClass) {
        LinkedList<Serializable> parsedIds = new LinkedList<Serializable>();
        for (ResourceIdentifier dataBody : dataBodies) {
            Serializable parsedId = targetResourceInformation.parseIdString(dataBody.getId());
            parsedIds.add(parsedId);
        }
        relationshipRepositoryForClass.setRelations(resource, parsedIds, relationshipField, queryAdapter);
    }

    @Override
    protected void processToOneRelationship(Object resource, ResourceInformation targetResourceInformation, ResourceField relationshipField, ResourceIdentifier dataBody, QueryAdapter queryAdapter, RelationshipRepositoryAdapter relationshipRepositoryForClass) {
        Serializable parsedId = null;
        if (dataBody != null) {
            parsedId = targetResourceInformation.parseIdString(dataBody.getId());
        }
        relationshipRepositoryForClass.setRelation(resource, parsedId, relationshipField, queryAdapter);
    }
}

