/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PropertyException;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionFieldAccessor
implements ResourceFieldAccessor {
    private Method getter;
    private Method setter;
    private Field field;
    private Class<?> resourceType;
    private String fieldName;
    private Class<?> fieldType;

    public ReflectionFieldAccessor(Class<?> resourceType, String fieldName, Class<?> fieldType) {
        if (fieldName == null) {
            throw new IllegalArgumentException("no fieldName provided");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("no resourceType provided");
        }
        if (fieldType == null) {
            throw new IllegalArgumentException("no fieldType provided");
        }
        this.resourceType = resourceType;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.getter = ClassUtils.findGetter(resourceType, fieldName);
        this.setter = ClassUtils.findSetter(resourceType, fieldName, fieldType);
        this.field = ClassUtils.findClassField(resourceType, fieldName);
        if (this.field != null && !Modifier.isPublic(this.field.getModifiers())) {
            this.field = null;
        }
    }

    @Override
    public Object getValue(Object resource) {
        if (resource == null) {
            String message = String.format("Cannot get value %s.%s for null", this.resourceType.getCanonicalName(), this.fieldName);
            throw new PropertyException(message, this.resourceType, this.fieldName);
        }
        try {
            if (this.field != null) {
                return this.field.get(resource);
            }
            if (this.getter != null) {
                return this.getter.invoke(resource, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new PropertyException(e, this.resourceType, this.fieldName);
        }
        String message = String.format("Cannot find an getter for %s.%s", this.resourceType.getCanonicalName(), this.fieldName);
        throw new PropertyException(message, this.resourceType, this.fieldName);
    }

    @Override
    public void setValue(Object resource, Object fieldValue) {
        block5: {
            if (resource == null) {
                String message = String.format("Cannot set value %s.%s for null", this.resourceType.getCanonicalName(), this.fieldName);
                throw new PropertyException(message, this.resourceType, this.fieldName);
            }
            try {
                Object mappedValue = PropertyUtils.prepareValue(fieldValue, this.fieldType);
                if (this.field != null) {
                    this.field.set(resource, mappedValue);
                    break block5;
                }
                if (this.setter != null) {
                    this.setter.invoke(resource, mappedValue);
                    break block5;
                }
                String message = String.format("Cannot find an setter for %s.%s", this.resourceType.getCanonicalName(), this.fieldName);
                throw new PropertyException(message, this.resourceType, this.fieldName);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new PropertyException(e, this.resourceType, this.fieldName);
            }
        }
    }
}

