/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.legacy.internal;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.DefaultQuerySpecDeserializer;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.QuerySpecConverter;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.legacy.queryParams.QueryParams;
import io.crnk.legacy.queryParams.RestrictedPaginationKeys;
import io.crnk.legacy.queryParams.RestrictedSortingValues;
import io.crnk.legacy.queryParams.include.Inclusion;
import io.crnk.legacy.queryParams.params.FilterParams;
import io.crnk.legacy.queryParams.params.IncludedFieldsParams;
import io.crnk.legacy.queryParams.params.IncludedRelationsParams;
import io.crnk.legacy.queryParams.params.SortingParams;
import io.crnk.legacy.queryParams.params.TypedParams;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultQuerySpecConverter
implements QuerySpecConverter {
    private ResourceRegistry resourceRegistry;
    private TypeParser typeParser;
    private DefaultQuerySpecDeserializer deserializer;

    public DefaultQuerySpecConverter(ModuleRegistry moduleRegistry) {
        this.resourceRegistry = moduleRegistry.getResourceRegistry();
        this.typeParser = moduleRegistry.getTypeParser();
        this.deserializer = new DefaultQuerySpecDeserializer();
    }

    @Override
    public QuerySpec fromParams(Class<?> rootType, QueryParams params) {
        QuerySpec querySpec = new QuerySpec(rootType);
        this.applyIncludedFields(querySpec, params);
        this.applySorting(querySpec, params);
        this.applyFiltering(querySpec, params);
        this.applyRelatedFields(querySpec, params);
        this.applyPaging(querySpec, params);
        return querySpec;
    }

    private Class<?> getResourceClass(String resourceType) {
        RegistryEntry registryEntry = this.resourceRegistry.getEntry(resourceType);
        if (registryEntry == null) {
            throw new IllegalArgumentException("resourceType " + resourceType + " not found");
        }
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        return resourceInformation.getResourceClass();
    }

    protected void applyPaging(QuerySpec rootQuerySpec, QueryParams queryParams) {
        Map<RestrictedPaginationKeys, Integer> pagination = queryParams.getPagination();
        if (pagination != null) {
            for (Map.Entry<RestrictedPaginationKeys, Integer> entry : pagination.entrySet()) {
                RestrictedPaginationKeys key = entry.getKey();
                if (key == RestrictedPaginationKeys.limit) {
                    rootQuerySpec.setLimit(entry.getValue().longValue());
                    continue;
                }
                if (key == RestrictedPaginationKeys.offset) {
                    rootQuerySpec.setOffset(entry.getValue().intValue());
                    continue;
                }
                throw new UnsupportedOperationException("not supported: " + (Object)((Object)key));
            }
        }
    }

    protected void applyFiltering(QuerySpec rootQuerySpec, QueryParams queryParams) {
        TypedParams<FilterParams> filters = queryParams.getFilters();
        if (filters != null && !filters.getParams().isEmpty()) {
            for (Map.Entry<String, FilterParams> typeEntry : filters.getParams().entrySet()) {
                FilterParams filterParams = typeEntry.getValue();
                Class<?> resourceClass = this.getResourceClass(typeEntry.getKey());
                QuerySpec querySpec = rootQuerySpec.getOrCreateQuerySpec(resourceClass);
                for (Map.Entry<String, Set<String>> entry : filterParams.getParams().entrySet()) {
                    String pathString = entry.getKey();
                    Set<String> stringValues = entry.getValue();
                    this.applyFilter(querySpec, pathString, stringValues);
                }
            }
        }
    }

    private void applyFilter(QuerySpec querySpec, String parameterName, Set<String> stringValues) {
        FilterOperator filterOp = null;
        String attributePathString = parameterName;
        for (FilterOperator op : this.deserializer.getSupportedOperators()) {
            String opSuffix = "." + op.toString().toLowerCase().replace("_", "");
            if (!parameterName.toLowerCase().endsWith(opSuffix)) continue;
            attributePathString = parameterName.substring(0, parameterName.length() - opSuffix.length());
            filterOp = op;
            break;
        }
        if (filterOp == null) {
            filterOp = this.deserializer.getDefaultOperator();
        }
        List<String> attributePath = this.splitPath(attributePathString);
        Class<?> attributeType = PropertyUtils.getPropertyClass(querySpec.getResourceClass(), attributePath);
        HashSet typedValues = new HashSet();
        for (String stringValue : stringValues) {
            Object value = this.typeParser.parse(stringValue, attributeType);
            typedValues.add(value);
        }
        HashSet value = typedValues.size() == 1 ? typedValues.iterator().next() : typedValues;
        querySpec.addFilter(new FilterSpec(attributePath, filterOp, value));
    }

    private List<String> splitPath(String pathString) {
        return Arrays.asList(pathString.split("\\."));
    }

    protected void applySorting(QuerySpec rootQuerySpec, QueryParams queryParams) {
        TypedParams<SortingParams> sorting = queryParams.getSorting();
        if (sorting != null && !sorting.getParams().isEmpty()) {
            for (Map.Entry<String, SortingParams> typeEntry : sorting.getParams().entrySet()) {
                SortingParams sortingParams = typeEntry.getValue();
                Class<?> resourceClass = this.getResourceClass(typeEntry.getKey());
                QuerySpec querySpec = rootQuerySpec.getOrCreateQuerySpec(resourceClass);
                for (Map.Entry<String, RestrictedSortingValues> entry : sortingParams.getParams().entrySet()) {
                    Direction dir = entry.getValue() == RestrictedSortingValues.desc ? Direction.DESC : Direction.ASC;
                    List<String> attributePath = this.splitPath(entry.getKey());
                    querySpec.addSort(new SortSpec(attributePath, dir));
                }
            }
        }
    }

    protected void applyIncludedFields(QuerySpec rootQuerySpec, QueryParams queryParams) {
        TypedParams<IncludedFieldsParams> includes = queryParams.getIncludedFields();
        if (includes != null && !includes.getParams().isEmpty()) {
            for (Map.Entry<String, IncludedFieldsParams> typeEntry : includes.getParams().entrySet()) {
                IncludedFieldsParams includeParams = typeEntry.getValue();
                Class<?> resourceClass = this.getResourceClass(typeEntry.getKey());
                QuerySpec querySpec = rootQuerySpec.getOrCreateQuerySpec(resourceClass);
                for (String inclusion : includeParams.getParams()) {
                    List<String> attributePath = this.splitPath(inclusion);
                    querySpec.includeField(attributePath);
                }
            }
        }
    }

    protected void applyRelatedFields(QuerySpec rootQuerySpec, QueryParams queryParams) {
        TypedParams<IncludedRelationsParams> includes = queryParams.getIncludedRelations();
        if (includes != null && !includes.getParams().isEmpty()) {
            for (Map.Entry<String, IncludedRelationsParams> typeEntry : includes.getParams().entrySet()) {
                IncludedRelationsParams includeParams = typeEntry.getValue();
                Class<?> resourceClass = this.getResourceClass(typeEntry.getKey());
                QuerySpec querySpec = rootQuerySpec.getOrCreateQuerySpec(resourceClass);
                for (Inclusion inclusion : includeParams.getParams()) {
                    List<String> attributePath = this.splitPath(inclusion.getPath());
                    querySpec.includeRelation(attributePath);
                }
            }
        }
    }
}

