/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.document;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.internal.jackson.DocumentDataDeserializer;
import io.crnk.core.engine.internal.jackson.NullableSerializer;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.resource.list.LinksContainer;
import io.crnk.core.resource.meta.MetaContainer;
import io.crnk.core.utils.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Document
implements MetaContainer,
LinksContainer {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(using=DocumentDataDeserializer.class)
    @JsonSerialize(using=NullableSerializer.class)
    private Nullable<Object> data = Nullable.empty();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Resource> included;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ObjectNode links;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ObjectNode meta;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ErrorData> errors;

    public Nullable<Object> getData() {
        return this.data;
    }

    public void setData(Nullable<Object> data) {
        PreconditionUtil.assertNotNull("make use of Nullable instead of null", data);
        this.data = data;
    }

    @Override
    public ObjectNode getLinks() {
        return this.links;
    }

    @Override
    public void setLinks(ObjectNode links) {
        this.links = links;
    }

    public List<Resource> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<Resource> includes) {
        this.included = includes;
    }

    @Override
    public ObjectNode getMeta() {
        return this.meta;
    }

    @Override
    public void setMeta(ObjectNode meta) {
        this.meta = meta;
    }

    public List<ErrorData> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ErrorData> errors) {
        this.errors = errors;
    }

    @JsonIgnore
    public boolean isMultiple() {
        return this.data.get() instanceof Collection;
    }

    @JsonIgnore
    public Nullable<Resource> getSingleData() {
        return this.data;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors, this.included, this.links, this.meta);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != Document.class) {
            return false;
        }
        Document other = (Document)obj;
        return Objects.equals(this.data, other.data) && Objects.equals(this.errors, other.errors) && Objects.equals(this.included, other.included) && Objects.equals(this.meta, other.meta) && Objects.equals(this.links, other.links);
    }

    @JsonIgnore
    public Nullable<List<Resource>> getCollectionData() {
        if (!this.data.isPresent()) {
            return Nullable.empty();
        }
        Object value = this.data.get();
        if (value == null) {
            return Nullable.of(Collections.emptyList());
        }
        if (!(value instanceof Iterable)) {
            return Nullable.of(Collections.singletonList((Resource)value));
        }
        return Nullable.of((List)value);
    }
}

