/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.InformationBuilder;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.information.DefaultInformationBuilder;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.RegistryEntryBuilder;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.legacy.internal.DirectResponseRelationshipEntry;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DefaultRegistryEntryBuilder
implements RegistryEntryBuilder {
    private final DefaultInformationBuilder informationBuilder;
    private ModuleRegistry moduleRegistry;
    private DefaultResourceRepository resourceRepository;
    private Map<String, DefaultRelationshipRepository> relationshipRepositoryMap = new HashMap<String, DefaultRelationshipRepository>();
    private InformationBuilder.Resource resource;

    public DefaultRegistryEntryBuilder(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.informationBuilder = moduleRegistry.getInformationBuilder();
    }

    @Override
    public RegistryEntryBuilder.ResourceRepository resourceRepository() {
        if (this.resourceRepository == null) {
            this.resourceRepository = new DefaultResourceRepository();
        }
        return this.resourceRepository;
    }

    @Override
    public InformationBuilder.Resource resource() {
        if (this.resource == null) {
            this.resource = this.informationBuilder.createResource(null, null);
        }
        return this.resource;
    }

    @Override
    public RegistryEntryBuilder.RelationshipRepository relationshipRepository(String targetResourceType) {
        DefaultRelationshipRepository repository = this.relationshipRepositoryMap.get(targetResourceType);
        if (repository == null) {
            repository = new DefaultRelationshipRepository(targetResourceType);
            this.relationshipRepositoryMap.put(targetResourceType, repository);
        }
        return repository;
    }

    @Override
    public RegistryEntry build() {
        ResourceInformation resourceInformation = this.resource.build();
        this.resourceRepository.information().setResourceInformation(resourceInformation);
        ResourceRepositoryInformation repositoryInformation = this.resourceRepository.information().build();
        final Object decoratedResourceRepository = this.moduleRegistry.decorateRepository(this.resourceRepository.instance);
        RepositoryInstanceBuilder repositoryInstanceBuilder = new RepositoryInstanceBuilder(null, this.resourceRepository.instance.getClass()){

            public Object buildRepository() {
                return decoratedResourceRepository;
            }
        };
        DirectResponseResourceEntry resourceEntry = new DirectResponseResourceEntry(repositoryInstanceBuilder);
        ArrayList<ResponseRelationshipEntry> relationshipEntries = new ArrayList<ResponseRelationshipEntry>();
        for (final DefaultRelationshipRepository relationshipRepository : this.relationshipRepositoryMap.values()) {
            final Object decoratedRelationshipRepository = this.moduleRegistry.decorateRepository(relationshipRepository.instance);
            Class<?> repositoryClass = relationshipRepository.information.getClass();
            RepositoryInstanceBuilder<Object> relationshipInstanceBuilder = new RepositoryInstanceBuilder<Object>(null, repositoryClass){

                @Override
                public Object buildRepository() {
                    return decoratedRelationshipRepository;
                }
            };
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry(relationshipInstanceBuilder){

                @Override
                public String getTargetResourceType() {
                    return relationshipRepository.targetResourceType;
                }
            };
            relationshipEntries.add(relationshipEntry);
        }
        RegistryEntry entry = new RegistryEntry(resourceInformation, repositoryInformation, resourceEntry, relationshipEntries);
        entry.initialize(this.moduleRegistry);
        return entry;
    }

    class DefaultRelationshipRepository
    implements RegistryEntryBuilder.RelationshipRepository {
        private final String targetResourceType;
        private InformationBuilder.RelationshipRepository information;
        private Object instance;

        public DefaultRelationshipRepository(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            this.information = DefaultRegistryEntryBuilder.this.informationBuilder.createRelationshipRepository(targetResourceType);
        }

        @Override
        public InformationBuilder.RelationshipRepository information() {
            return this.information;
        }

        @Override
        public void instance(Object instance) {
            this.instance = instance;
        }
    }

    class DefaultResourceRepository
    implements RegistryEntryBuilder.ResourceRepository {
        private Object instance;
        private InformationBuilder.ResourceRepository information;

        public DefaultResourceRepository() {
            this.information = DefaultRegistryEntryBuilder.this.informationBuilder.createResourceRepository();
        }

        @Override
        public InformationBuilder.ResourceRepository information() {
            return this.information;
        }

        @Override
        public void instance(Object instance) {
            this.instance = instance;
        }
    }
}

