/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.internal.dispatcher.ControllerLookup;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.dispatcher.DefaultControllerLookup;
import io.crnk.core.engine.internal.dispatcher.controller.BaseController;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.ResourceRegistry;
import java.util.LinkedList;
import java.util.List;

public class ControllerRegistryBuilder {
    private final ResourceRegistry resourceRegistry;
    private final TypeParser typeParser;
    private final ObjectMapper objectMapper;
    private final DocumentMapper documentMapper;
    private final PropertiesProvider propertiesProvider;
    private final List<ResourceModificationFilter> modificationFilters;

    public ControllerRegistryBuilder(ResourceRegistry resourceRegistry, TypeParser typeParser, ObjectMapper objectMapper, PropertiesProvider propertiesProvider, ResourceFilterDirectory resourceFilterDirectory, List<ResourceModificationFilter> modificationFilters) {
        this.resourceRegistry = resourceRegistry;
        this.typeParser = typeParser;
        this.propertiesProvider = propertiesProvider;
        this.objectMapper = objectMapper;
        this.documentMapper = new DocumentMapper(resourceRegistry, objectMapper, propertiesProvider, resourceFilterDirectory);
        this.modificationFilters = modificationFilters;
    }

    private static ControllerRegistry build(ControllerLookup lookup) {
        LinkedList<BaseController> controllers = new LinkedList<BaseController>();
        controllers.addAll(lookup.getControllers());
        return new ControllerRegistry(controllers);
    }

    public ControllerRegistry build() {
        return ControllerRegistryBuilder.build(new DefaultControllerLookup(this.resourceRegistry, this.propertiesProvider, this.typeParser, this.objectMapper, this.documentMapper, this.modificationFilters));
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }
}

