/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.filter.ResourceRelationshipModificationType;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourceUpsert;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.ResourceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class RelationshipsResourcePost
extends RelationshipsResourceUpsert {
    public RelationshipsResourcePost(ResourceRegistry resourceRegistry, TypeParser typeParser, List<ResourceModificationFilter> modificationFilters) {
        super(resourceRegistry, typeParser, null, modificationFilters);
    }

    @Override
    public HttpMethod method() {
        return HttpMethod.POST;
    }

    @Override
    public void processToManyRelationship(Object resource, ResourceInformation targetResourceInformation, ResourceField relationshipField, Iterable<ResourceIdentifier> dataBodies, QueryAdapter queryAdapter, RelationshipRepositoryAdapter relationshipRepositoryForClass) {
        List<ResourceIdentifier> resourceIds = new ArrayList<ResourceIdentifier>();
        for (ResourceIdentifier dataBody : dataBodies) {
            resourceIds.add(dataBody);
        }
        for (ResourceModificationFilter filter : this.modificationFilters) {
            resourceIds = filter.modifyManyRelationship(resource, relationshipField, ResourceRelationshipModificationType.ADD, resourceIds);
        }
        LinkedList<Serializable> parsedIds = new LinkedList<Serializable>();
        for (ResourceIdentifier resourceId : resourceIds) {
            Serializable parsedId = targetResourceInformation.parseIdString(resourceId.getId());
            parsedIds.add(parsedId);
        }
        relationshipRepositoryForClass.addRelations(resource, parsedIds, relationshipField, queryAdapter);
    }

    @Override
    protected void processToOneRelationship(Object resource, ResourceInformation targetResourceInformation, ResourceField relationshipField, ResourceIdentifier resourceId, QueryAdapter queryAdapter, RelationshipRepositoryAdapter relationshipRepositoryForClass) {
        for (ResourceModificationFilter filter : this.modificationFilters) {
            resourceId = filter.modifyOneRelationship(resource, relationshipField, resourceId);
        }
        Serializable parsedId = null;
        if (resourceId != null) {
            parsedId = targetResourceInformation.parseIdString(resourceId.getId());
        }
        relationshipRepositoryForClass.setRelation(resource, parsedId, relationshipField, queryAdapter);
    }
}

