/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module.internal;

import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.ResourceFilter;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFilterDirectoryImpl
implements ResourceFilterDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFilterDirectoryImpl.class);
    private final List<ResourceFilter> filters;
    private final HttpRequestContextProvider requestContextProvider;
    private final ResourceRegistry resourceRegistry;

    public ResourceFilterDirectoryImpl(List<ResourceFilter> filters, HttpRequestContextProvider requestContextProvider, ResourceRegistry resourceRegistry) {
        this.filters = filters;
        this.requestContextProvider = requestContextProvider;
        this.resourceRegistry = resourceRegistry;
    }

    @Override
    public FilterBehavior get(ResourceInformation resourceInformation, HttpMethod method) {
        ResourceFilter filter;
        Map<Object, FilterBehavior> map = this.getCache(method);
        FilterBehavior behavior = map.get(resourceInformation);
        if (behavior != null) {
            return behavior;
        }
        behavior = FilterBehavior.NONE;
        Iterator<ResourceFilter> iterator = this.filters.iterator();
        while (iterator.hasNext() && (behavior = behavior.merge((filter = iterator.next()).filterResource(resourceInformation, method))) != FilterBehavior.FORBIDDEN) {
        }
        map.put(resourceInformation, behavior);
        return behavior;
    }

    @Override
    public FilterBehavior get(ResourceField field, HttpMethod method) {
        ResourceFilter filter;
        Map<Object, FilterBehavior> map = this.getCache(method);
        FilterBehavior behavior = map.get(field);
        if (behavior != null) {
            return behavior;
        }
        behavior = FilterBehavior.NONE;
        Iterator<ResourceFilter> iterator = this.filters.iterator();
        while (iterator.hasNext() && (behavior = behavior.merge((filter = iterator.next()).filterField(field, method))) != FilterBehavior.FORBIDDEN) {
        }
        if (field.getResourceFieldType() == ResourceFieldType.RELATIONSHIP) {
            String oppositeResourceType = field.getOppositeResourceType();
            RegistryEntry oppositeRegistryEntry = this.resourceRegistry.getEntry(oppositeResourceType);
            if (oppositeRegistryEntry != null) {
                PreconditionUtil.assertNotNull(oppositeResourceType, oppositeRegistryEntry);
                ResourceInformation oppositeResourceInformation = oppositeRegistryEntry.getResourceInformation();
                behavior = behavior.merge(this.get(oppositeResourceInformation, HttpMethod.GET));
            } else {
                LOGGER.warn("opposite side {} not found", (Object)oppositeResourceType);
            }
        }
        map.put(field, behavior);
        return behavior;
    }

    private Map<Object, FilterBehavior> getCache(HttpMethod method) {
        String key = ResourceFilterDirectoryImpl.class.getSimpleName() + (Object)((Object)method);
        HttpRequestContext requestContext = this.requestContextProvider.getRequestContext();
        if (requestContext == null) {
            return new HashMap<Object, FilterBehavior>();
        }
        HashMap cache = (HashMap)requestContext.getRequestAttribute(key);
        if (cache == null) {
            cache = new HashMap();
            requestContext.setRequestAttribute(key, cache);
        }
        return cache;
    }
}

