/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.links.SelfLinksInformation;
import io.crnk.core.resource.meta.MetaInformation;
import java.util.List;

public class ResourceMapper {
    private static final String SELF_FIELD_NAME = "self";
    private static final String RELATED_FIELD_NAME = "related";
    private final ResourceFilterDirectory resourceFilterDirectory;
    private DocumentMapperUtil util;
    private boolean client;
    private ObjectMapper objectMapper;

    public ResourceMapper(DocumentMapperUtil util, boolean client, ObjectMapper objectMapper, ResourceFilterDirectory resourceFilterDirectory) {
        this.util = util;
        this.client = client;
        this.objectMapper = objectMapper;
        this.resourceFilterDirectory = resourceFilterDirectory;
    }

    public Resource toData(Object entity, QueryAdapter queryAdapter) {
        if (entity instanceof Resource) {
            return (Resource)entity;
        }
        Class<?> dataClass = entity.getClass();
        ResourceInformation resourceInformation = this.util.getResourceInformation(dataClass);
        Resource resource = new Resource();
        resource.setId(this.util.getIdString(entity, resourceInformation));
        resource.setType(resourceInformation.getResourceType());
        if (!this.client) {
            this.util.setLinks(resource, this.getResourceLinks(entity, resourceInformation));
            this.util.setMeta(resource, this.getResourceMeta(entity, resourceInformation));
        }
        this.setAttributes(resource, entity, resourceInformation, queryAdapter);
        this.setRelationships(resource, entity, resourceInformation, queryAdapter);
        return resource;
    }

    private MetaInformation getResourceMeta(Object entity, ResourceInformation resourceInformation) {
        if (resourceInformation.getMetaField() != null) {
            return (MetaInformation)resourceInformation.getMetaField().getAccessor().getValue(entity);
        }
        return null;
    }

    public LinksInformation getResourceLinks(Object entity, ResourceInformation resourceInformation) {
        SelfLinksInformation self;
        LinksInformation info = resourceInformation.getLinksField() != null ? (LinksInformation)resourceInformation.getLinksField().getAccessor().getValue(entity) : new DocumentMapperUtil.DefaultSelfRelatedLinksInformation();
        if (info instanceof SelfLinksInformation && (self = (SelfLinksInformation)info).getSelf() == null) {
            self.setSelf(this.util.getSelfUrl(resourceInformation, entity));
        }
        return info;
    }

    protected void setAttributes(Resource resource, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter) {
        List<ResourceField> fields = DocumentMapperUtil.getRequestedFields(resourceInformation, queryAdapter, resourceInformation.getAttributeFields(), false);
        for (ResourceField field : fields) {
            if (this.isIgnored(field) || !field.getAccess().isReadable()) continue;
            this.setAttribute(resource, field, entity);
        }
    }

    protected boolean isIgnored(ResourceField field) {
        return this.resourceFilterDirectory != null && this.resourceFilterDirectory.get(field, HttpMethod.GET) != FilterBehavior.NONE;
    }

    protected void setAttribute(Resource resource, ResourceField field, Object entity) {
        Object value = field.getAccessor().getValue(entity);
        JsonNode valueNode = this.objectMapper.valueToTree(value);
        resource.getAttributes().put(field.getJsonName(), valueNode);
    }

    protected void setRelationships(Resource resource, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter) {
        List<ResourceField> fields = DocumentMapperUtil.getRequestedFields(resourceInformation, queryAdapter, resourceInformation.getRelationshipFields(), true);
        for (ResourceField field : fields) {
            if (this.isIgnored(field)) continue;
            this.setRelationship(resource, field, entity, resourceInformation, queryAdapter);
        }
    }

    protected void setRelationship(Resource resource, ResourceField field, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter) {
        ObjectNode relationshipLinks = this.objectMapper.createObjectNode();
        relationshipLinks.put(SELF_FIELD_NAME, this.util.getRelationshipLink(resourceInformation, entity, field, false));
        relationshipLinks.put(RELATED_FIELD_NAME, this.util.getRelationshipLink(resourceInformation, entity, field, true));
        Relationship relationship = new Relationship();
        relationship.setLinks(relationshipLinks);
        resource.getRelationships().put(field.getJsonName(), relationship);
    }
}

