/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.crnk.core.engine.dispatcher.RequestDispatcher;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.internal.dispatcher.path.ActionPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathBuilder;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.module.Module;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiRequestProcessor
implements HttpRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonApiRequestProcessor.class);
    private Module.ModuleContext moduleContext;

    public JsonApiRequestProcessor(Module.ModuleContext moduleContext) {
        this.moduleContext = moduleContext;
    }

    public static boolean isJsonApiRequest(HttpRequestContext requestContext) {
        String contentType;
        if (!(!requestContext.getMethod().equalsIgnoreCase(HttpMethod.PATCH.toString()) && !requestContext.getMethod().equalsIgnoreCase(HttpMethod.POST.toString()) || (contentType = requestContext.getRequestHeader("Content-Type")) != null && contentType.startsWith("application/vnd.api+json"))) {
            return false;
        }
        boolean acceptsJsonApi = requestContext.accepts("application/vnd.api+json");
        boolean acceptsAny = requestContext.acceptsAny();
        return acceptsJsonApi || acceptsAny;
    }

    @Override
    public void process(HttpRequestContext requestContext) throws IOException {
        if (JsonApiRequestProcessor.isJsonApiRequest(requestContext)) {
            ResourceRegistry resourceRegistry = this.moduleContext.getResourceRegistry();
            RequestDispatcher requestDispatcher = this.moduleContext.getRequestDispatcher();
            String path = requestContext.getPath();
            JsonPath jsonPath = new PathBuilder(resourceRegistry).build(path);
            Map<String, Set<String>> parameters = requestContext.getRequestParameters();
            String method = requestContext.getMethod();
            if (jsonPath instanceof ActionPath) {
                requestDispatcher.dispatchAction(path, method, parameters);
            } else if (jsonPath != null) {
                byte[] requestBody = requestContext.getRequestBody();
                Document document = null;
                if (requestBody != null && requestBody.length > 0) {
                    ObjectMapper objectMapper = this.moduleContext.getObjectMapper();
                    try {
                        document = (Document)objectMapper.readerFor(Document.class).readValue(requestBody);
                    }
                    catch (JsonProcessingException e) {
                        String message = "Json Parsing failed";
                        this.setResponse(requestContext, this.buildBadRequestResponse("Json Parsing failed", e.getMessage()));
                        LOGGER.error("Json Parsing failed", (Throwable)e);
                        return;
                    }
                }
                RepositoryMethodParameterProvider parameterProvider = requestContext.getRequestParameterProvider();
                Response crnkResponse = requestDispatcher.dispatchRequest(path, method, parameters, parameterProvider, document);
                this.setResponse(requestContext, crnkResponse);
            }
        }
    }

    private Response buildBadRequestResponse(String message, String detail) {
        Document responseDocument = new Document();
        responseDocument.setErrors(Lists.newArrayList((Object[])new ErrorData[]{ErrorData.builder().setStatus(String.valueOf(400)).setTitle(message).setDetail(detail).build()}));
        return new Response(responseDocument, 400);
    }

    private void setResponse(HttpRequestContext requestContext, Response crnkResponse) throws IOException {
        if (crnkResponse != null) {
            ObjectMapper objectMapper = this.moduleContext.getObjectMapper();
            String responseBody = objectMapper.writeValueAsString((Object)crnkResponse.getDocument());
            requestContext.setResponseHeader("Content-Type", "application/vnd.api+json; charset=utf-8");
            requestContext.setResponse((int)crnkResponse.getHttpStatus(), responseBody);
        }
    }
}

