/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.document;

import io.crnk.core.engine.document.ErrorDataBuilder;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class ErrorData
implements Serializable {
    private final String id;
    private final String aboutLink;
    private final String status;
    private final String code;
    private final String title;
    private final String detail;
    private final String sourcePointer;
    private final String sourceParameter;
    private final Map<String, Object> meta;

    @Deprecated
    public ErrorData(String id, String aboutLink, String status, String code, String title, String detail, String sourcePointer, String sourceParameter, Map<String, Object> meta) {
        this.id = id;
        this.aboutLink = aboutLink;
        this.status = status;
        this.code = code;
        this.title = title;
        this.detail = detail;
        this.sourcePointer = sourcePointer;
        this.sourceParameter = sourceParameter;
        this.meta = meta == null ? null : Collections.unmodifiableMap(meta);
    }

    protected ErrorData(ErrorDataBuilder builder) {
        this.id = builder.getId();
        this.aboutLink = builder.getAboutLink();
        this.status = builder.getStatus();
        this.code = builder.getCode();
        this.title = builder.getTitle();
        this.detail = builder.getDetail();
        this.sourcePointer = builder.getSourcePointer();
        this.sourceParameter = builder.getSourceParameter();
        this.meta = builder.getMeta();
    }

    public static ErrorDataBuilder builder() {
        return new ErrorDataBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getAboutLink() {
        return this.aboutLink;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getSourcePointer() {
        return this.sourcePointer;
    }

    public String getSourceParameter() {
        return this.sourceParameter;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorData)) {
            return false;
        }
        ErrorData that = (ErrorData)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.aboutLink, that.aboutLink) && Objects.equals(this.status, that.status) && Objects.equals(this.code, that.code) && Objects.equals(this.title, that.title) && Objects.equals(this.detail, that.detail) && Objects.equals(this.sourceParameter, that.sourceParameter) && Objects.equals(this.sourcePointer, that.sourcePointer) && Objects.equals(this.meta, that.meta);
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.aboutLink, this.status, this.code, this.title, this.detail, this.sourceParameter, this.sourcePointer, this.meta);
    }

    public String toString() {
        return "ErrorData{id='" + this.id + '\'' + ", aboutLink='" + this.aboutLink + '\'' + ", status='" + this.status + '\'' + ", code='" + this.code + '\'' + ", title='" + this.title + '\'' + ", detail='" + this.detail + '\'' + ", sourcePointer='" + this.sourcePointer + '\'' + ", sourceParameter='" + this.sourceParameter + '\'' + ", meta=" + this.meta + '}';
    }
}

