/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.registry;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.registry.ResourceRegistryImpl;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistryPartBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceRegistryPart
extends ResourceRegistryPartBase {
    private final Logger logger = LoggerFactory.getLogger(ResourceRegistryImpl.class);
    private final Map<String, RegistryEntry> resourcesByType = new HashMap<String, RegistryEntry>();
    private final Map<Class, RegistryEntry> resourcesByClass = new HashMap<Class, RegistryEntry>();

    @Override
    public RegistryEntry addEntry(RegistryEntry entry) {
        ResourceInformation resourceInformation = entry.getResourceInformation();
        Class<?> resourceClass = resourceInformation.getResourceClass();
        String resourceType = resourceInformation.getResourceType();
        PreconditionUtil.assertNotNull("no resourceType set", resourceType);
        this.resourcesByClass.put(resourceClass, entry);
        this.resourcesByType.put(resourceType, entry);
        this.logger.debug("Added resource {} to ResourceRegistry", (Object)entry.getResourceInformation().getResourceType());
        this.notifyChange();
        return entry;
    }

    @Override
    public boolean hasEntry(Class<?> clazz) {
        return this.getEntry(clazz) != null;
    }

    @Override
    public boolean hasEntry(String resourceType) {
        return this.getEntry(resourceType) != null;
    }

    @Override
    public RegistryEntry getEntry(Class<?> resourceClass) {
        return this.resourcesByClass.get(resourceClass);
    }

    public Set<RegistryEntry> getResources() {
        return Collections.unmodifiableSet(new HashSet<RegistryEntry>(this.resourcesByType.values()));
    }

    @Override
    public RegistryEntry getEntry(String resourceType) {
        return this.resourcesByType.get(resourceType);
    }
}

