/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.filter.ResourceRelationshipModificationType;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.AnyResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.properties.ResourceFieldImmutableWriteBehavior;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.ForbiddenException;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.exception.RequestBodyException;
import io.crnk.core.exception.ResourceException;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceUpsert
extends ResourceIncludeField {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper objectMapper;
    protected final ResourceFilterDirectory resourceFilterDirectory;
    protected final List<ResourceModificationFilter> modificationFilters;
    private PropertiesProvider propertiesProvider;

    public ResourceUpsert(ResourceRegistry resourceRegistry, PropertiesProvider propertiesProvider, TypeParser typeParser, ObjectMapper objectMapper, DocumentMapper documentMapper, List<ResourceModificationFilter> modificationFilters) {
        super(resourceRegistry, typeParser, documentMapper);
        this.propertiesProvider = propertiesProvider;
        this.modificationFilters = modificationFilters;
        this.objectMapper = objectMapper;
        this.resourceFilterDirectory = documentMapper != null ? documentMapper.getFilterBehaviorManager() : null;
    }

    protected Resource getRequestBody(Document requestDocument, JsonPath path, HttpMethod method) {
        String resourceType = path.getResourceType();
        this.assertRequestDocument(requestDocument, method, resourceType);
        if (!requestDocument.getData().isPresent() || requestDocument.getData().get() == null) {
            throw new RequestBodyException(method, resourceType, "No data field in the body.");
        }
        if (requestDocument.getData().get() instanceof Collection) {
            throw new RequestBodyException(method, resourceType, "Multiple data in body");
        }
        Resource resourceBody = (Resource)requestDocument.getData().get();
        RegistryEntry bodyRegistryEntry = this.resourceRegistry.getEntry(resourceBody.getType());
        if (bodyRegistryEntry == null) {
            throw new RepositoryNotFoundException(resourceBody.getType());
        }
        return resourceBody;
    }

    protected RegistryEntry getRegistryEntry(JsonPath jsonPath) {
        String resourceType = jsonPath.getResourceType();
        return this.getRegistryEntry(resourceType);
    }

    protected Object newResource(ResourceInformation resourceInformation, Resource dataBody) {
        ResourceInstanceBuilder builder = resourceInformation.getInstanceBuilder();
        return builder.buildResource(dataBody);
    }

    protected void setId(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        if (dataBody.getId() != null) {
            String id = dataBody.getId();
            Serializable castedId = resourceInformation.parseIdString(id);
            ResourceField idField = resourceInformation.getIdField();
            idField.getAccessor().setValue(instance, castedId);
        }
    }

    protected Set<String> getLoadedRelationshipNames(Resource resourceBody) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Relationship> entry : resourceBody.getRelationships().entrySet()) {
            if (entry.getValue() == null || entry.getValue().getData() == null) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    protected void setAttributes(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        if (dataBody.getAttributes() != null) {
            for (Map.Entry<String, JsonNode> entry : dataBody.getAttributes().entrySet()) {
                String attributeName = entry.getKey();
                this.setAttribute(resourceInformation, instance, attributeName, entry.getValue());
            }
        }
    }

    private void setAttribute(ResourceInformation resourceInformation, Object instance, String attributeName, JsonNode valueNode) {
        ResourceField field = resourceInformation.findAttributeFieldByName(attributeName);
        if (this.canModifyField(resourceInformation, attributeName, field)) {
            try {
                if (field != null) {
                    Object value;
                    Type valueType = field.getGenericType();
                    if (valueNode != null) {
                        JavaType jacksonValueType = this.objectMapper.getTypeFactory().constructType(valueType);
                        ObjectReader reader = this.objectMapper.reader().forType(jacksonValueType);
                        value = reader.readValue(valueNode);
                    } else {
                        value = null;
                    }
                    for (ResourceModificationFilter filter : this.modificationFilters) {
                        value = filter.modifyAttribute(instance, field, attributeName, value);
                    }
                    field.getAccessor().setValue(instance, value);
                } else if (resourceInformation.getAnyFieldAccessor() != null) {
                    AnyResourceFieldAccessor anyFieldAccessor = resourceInformation.getAnyFieldAccessor();
                    Object value = this.objectMapper.reader().forType(Object.class).readValue(valueNode);
                    for (ResourceModificationFilter filter : this.modificationFilters) {
                        value = filter.modifyAttribute(instance, field, attributeName, value);
                    }
                    anyFieldAccessor.setValue(instance, attributeName, value);
                }
            }
            catch (IOException e) {
                throw new ResourceException(String.format("Exception while setting %s.%s=%s due to %s", instance, attributeName, valueNode, e.getMessage()), e);
            }
        }
    }

    protected boolean canModifyField(ResourceInformation resourceInformation, String fieldName, ResourceField field) {
        if (field == null) {
            return true;
        }
        HttpMethod method = this.getHttpMethod();
        ResourceFieldAccess access = field.getAccess();
        boolean modifiable = method == HttpMethod.POST ? access.isPostable() : access.isPatchable();
        FilterBehavior filterBehavior = modifiable ? FilterBehavior.NONE : this.getDefaultFilterBehavior();
        if ((filterBehavior = filterBehavior.merge(this.resourceFilterDirectory.get(field, method))) == FilterBehavior.NONE) {
            return true;
        }
        if (filterBehavior == FilterBehavior.FORBIDDEN) {
            throw new ForbiddenException("field '" + fieldName + "' cannot be modified");
        }
        PreconditionUtil.assertEquals("unknown behavior", (Object)FilterBehavior.IGNORED, (Object)filterBehavior);
        return false;
    }

    public FilterBehavior getDefaultFilterBehavior() {
        String strBehavior = this.propertiesProvider.getProperty("crnk.config.resource.immutableWrite");
        ResourceFieldImmutableWriteBehavior behavior = strBehavior != null ? ResourceFieldImmutableWriteBehavior.valueOf(strBehavior) : ResourceFieldImmutableWriteBehavior.IGNORE;
        return behavior == ResourceFieldImmutableWriteBehavior.IGNORE ? FilterBehavior.IGNORED : FilterBehavior.FORBIDDEN;
    }

    protected abstract HttpMethod getHttpMethod();

    Object buildNewResource(RegistryEntry registryEntry, Resource dataBody, String resourceName) {
        PreconditionUtil.verify(dataBody != null, "No data field in the body.", new Object[0]);
        PreconditionUtil.verify(resourceName.equals(dataBody.getType()), "Inconsistent type definition between path and body: body type: %s, request type: %s", dataBody.getType(), resourceName);
        Class<?> resourceClass = registryEntry.getResourceInformation().getResourceClass();
        return ClassUtils.newInstance(resourceClass);
    }

    protected void setRelations(Object newResource, RegistryEntry registryEntry, Resource resource, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, boolean ignoreMissing) {
        if (resource.getRelationships() != null) {
            for (Map.Entry<String, Relationship> property : resource.getRelationships().entrySet()) {
                ResourceInformation resourceInformation;
                ResourceField field;
                String propertyName = property.getKey();
                Relationship relationship = property.getValue();
                if (relationship == null || (field = (resourceInformation = registryEntry.getResourceInformation()).findRelationshipFieldByName(propertyName)) == null && ignoreMissing) continue;
                if (field == null) {
                    throw new ResourceException(String.format("Invalid relationship name: %s for %s", property.getKey(), resourceInformation.getResourceType()));
                }
                if (field.isCollection()) {
                    this.setRelationsField(newResource, registryEntry, property, queryAdapter, parameterProvider);
                    continue;
                }
                this.setRelationField(newResource, registryEntry, propertyName, relationship, queryAdapter, parameterProvider);
            }
        }
    }

    protected void setRelationsField(Object newResource, RegistryEntry registryEntry, Map.Entry<String, Relationship> property, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Relationship relationship = property.getValue();
        if (relationship.getData().isPresent()) {
            String propertyName = property.getKey();
            ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(propertyName);
            LinkedList<Object> relationships = new LinkedList<Object>();
            List<ResourceIdentifier> resourceIds = relationship.getCollectionData().get();
            for (ResourceModificationFilter filter : this.modificationFilters) {
                resourceIds = filter.modifyManyRelationship(newResource, relationshipField, ResourceRelationshipModificationType.SET, resourceIds);
            }
            for (ResourceIdentifier resourceId : resourceIds) {
                RegistryEntry entry = this.resourceRegistry.getEntry(resourceId.getType());
                Class<?> idFieldType = entry.getResourceInformation().getIdField().getType();
                Serializable castedRelationshipId = (Serializable)this.typeParser.parse(resourceId.getId(), idFieldType);
                Object relationObject = this.fetchRelatedObject(entry, castedRelationshipId, parameterProvider, queryAdapter);
                relationships.add(relationObject);
            }
            PropertyUtils.setProperty(newResource, relationshipField.getUnderlyingName(), relationships);
        }
    }

    protected void setRelationField(Object newResource, RegistryEntry registryEntry, String relationshipName, Relationship relationship, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        if (relationship.getData().isPresent()) {
            Object relationObject;
            ResourceIdentifier relationshipId = (ResourceIdentifier)relationship.getData().get();
            ResourceField relationshipFieldByName = registryEntry.getResourceInformation().findRelationshipFieldByName(relationshipName);
            if (relationshipFieldByName == null) {
                throw new ResourceException(String.format("Invalid relationship name: %s", relationshipName));
            }
            for (ResourceModificationFilter filter : this.modificationFilters) {
                relationshipId = filter.modifyOneRelationship(newResource, relationshipFieldByName, relationshipId);
            }
            if (relationshipId != null) {
                RegistryEntry entry = this.resourceRegistry.getEntry(relationshipId.getType());
                Class<?> idFieldType = entry.getResourceInformation().getIdField().getType();
                Serializable castedRelationshipId = (Serializable)this.typeParser.parse(relationshipId.getId(), idFieldType);
                relationObject = this.fetchRelatedObject(entry, castedRelationshipId, parameterProvider, queryAdapter);
            } else {
                relationObject = null;
            }
            relationshipFieldByName.getAccessor().setValue(newResource, relationObject);
        }
    }

    protected Object fetchRelatedObject(RegistryEntry entry, Serializable relationId, RepositoryMethodParameterProvider parameterProvider, QueryAdapter queryAdapter) {
        return entry.getResourceRepository(parameterProvider).findOne(relationId, queryAdapter).getEntity();
    }
}

