/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.internal.document.mapper.IncludeLookupSetter;
import io.crnk.core.engine.internal.document.mapper.ResourceMapper;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class DocumentMapper {
    private final ResourceFilterDirectory resourceFilterDirectory;
    protected PropertiesProvider propertiesProvider;
    private DocumentMapperUtil util;
    private ResourceMapper resourceMapper;
    private IncludeLookupSetter includeLookupSetter;
    private boolean client;

    public DocumentMapper(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider, ResourceFilterDirectory resourceFilterDirectory) {
        this(resourceRegistry, objectMapper, propertiesProvider, resourceFilterDirectory, false);
    }

    public DocumentMapper(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider, ResourceFilterDirectory resourceFilterDirectory, boolean client) {
        this.propertiesProvider = propertiesProvider;
        this.client = client;
        this.resourceFilterDirectory = resourceFilterDirectory;
        PreconditionUtil.assertTrue("filterBehavior necessary on server-side", client || resourceFilterDirectory != null);
        this.util = new DocumentMapperUtil(resourceRegistry, objectMapper, propertiesProvider);
        this.resourceMapper = this.newResourceMapper(this.util, client, objectMapper);
        this.includeLookupSetter = new IncludeLookupSetter(resourceRegistry, this.resourceMapper, propertiesProvider);
    }

    public ResourceFilterDirectory getFilterBehaviorManager() {
        return this.resourceFilterDirectory;
    }

    protected ResourceMapper newResourceMapper(DocumentMapperUtil util, boolean client, ObjectMapper objectMapper) {
        return new ResourceMapper(util, client, objectMapper, this.resourceFilterDirectory);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter) {
        return this.toDocument(response, queryAdapter, null);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Set<String> eagerLoadedRelations = Collections.emptySet();
        return this.toDocument(response, queryAdapter, parameterProvider, eagerLoadedRelations);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> additionalEagerLoadedRelations) {
        if (response == null) {
            return null;
        }
        Document doc = new Document();
        this.addErrors(doc, response.getErrors());
        this.util.setMeta(doc, response.getMetaInformation());
        this.util.setLinks(doc, response.getLinksInformation());
        this.addData(doc, response.getEntity(), queryAdapter);
        this.addRelationDataAndInclusions(doc, response.getEntity(), queryAdapter, parameterProvider, additionalEagerLoadedRelations);
        return doc;
    }

    private void addRelationDataAndInclusions(Document doc, Object entity, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> additionalEagerLoadedRelations) {
        if (doc.getData().isPresent() && !this.client) {
            this.includeLookupSetter.setIncludedElements(doc, entity, queryAdapter, parameterProvider, additionalEagerLoadedRelations);
        }
    }

    private void addData(Document doc, Object entity, QueryAdapter queryAdapter) {
        if (entity != null) {
            if (entity instanceof Iterable) {
                ArrayList<Resource> dataList = new ArrayList<Resource>();
                for (Object obj : (Iterable)entity) {
                    dataList.add(this.resourceMapper.toData(obj, queryAdapter));
                }
                doc.setData(Nullable.of(dataList));
            } else {
                doc.setData(Nullable.of(this.resourceMapper.toData(entity, queryAdapter)));
            }
        }
    }

    private void addErrors(Document doc, Iterable<ErrorData> errors) {
        if (errors != null) {
            ArrayList<ErrorData> errorList = new ArrayList<ErrorData>();
            for (ErrorData error : errors) {
                errorList.add(error);
            }
            doc.setErrors(errorList);
        }
    }
}

