/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.crnk.core.engine.internal.utils.SerializerUtil;
import io.crnk.core.resource.links.LinksInformation;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LinksInformationSerializer
extends JsonSerializer<LinksInformation> {
    public void serialize(LinksInformation value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        Method[] methods;
        gen.writeStartObject();
        for (Method method : methods = value.getClass().getDeclaredMethods()) {
            if (!this.usableGetter(method)) continue;
            String link = this.getValue(value, method);
            String fieldName = this.getFieldName(method);
            this.writeObjectLink(fieldName, link, gen);
        }
        gen.writeEndObject();
    }

    private boolean usableGetter(Method method) {
        boolean isGetter = method.getName().startsWith("get");
        boolean returnsString = String.class.equals(method.getReturnType());
        return isGetter && returnsString;
    }

    private String getValue(Object object, Method method) {
        try {
            if (method.isAnnotationPresent(JsonIgnore.class)) {
                return null;
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object value = method.invoke(object, new Object[0]);
            return (String)value;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private String getFieldName(Method method) {
        String name = method.getName();
        return name.substring(3, 4).toLowerCase() + name.substring(4);
    }

    private void writeObjectLink(String fieldName, String value, JsonGenerator gen) throws IOException {
        if (value != null) {
            gen.writeObjectFieldStart(fieldName);
            gen.writeStringField(SerializerUtil.HREF, value);
            gen.writeEndObject();
        }
    }

    public Class<LinksInformation> handledType() {
        return LinksInformation.class;
    }
}

