/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.RequestDispatcher;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.RepositoryFilter;
import io.crnk.core.engine.filter.ResourceFilter;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.information.InformationBuilder;
import io.crnk.core.engine.information.contributor.ResourceFieldContributor;
import io.crnk.core.engine.information.contributor.ResourceFieldContributorContext;
import io.crnk.core.engine.information.repository.RelationshipRepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformationProvider;
import io.crnk.core.engine.information.repository.RepositoryInformationProviderContext;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.information.resource.ResourceInformationProviderContext;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistryBuilder;
import io.crnk.core.engine.internal.information.DefaultInformationBuilder;
import io.crnk.core.engine.internal.registry.DefaultRegistryEntryBuilder;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.Decorator;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.NullPropertiesProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.RegistryEntryBuilder;
import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.engine.security.SecurityProvider;
import io.crnk.core.module.InitializingModule;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleExtension;
import io.crnk.core.module.ModuleExtensionAware;
import io.crnk.core.module.SimpleModule;
import io.crnk.core.module.discovery.MultiResourceLookup;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.module.internal.DefaultRepositoryInformationProviderContext;
import io.crnk.core.module.internal.ResourceFilterDirectoryImpl;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.decorate.RelationshipRepositoryDecorator;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import io.crnk.core.repository.decorate.ResourceRepositoryDecorator;
import io.crnk.core.utils.Optional;
import io.crnk.core.utils.Prioritizable;
import io.crnk.legacy.internal.DirectResponseRelationshipEntry;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.registry.AnnotatedRelationshipEntryBuilder;
import io.crnk.legacy.registry.AnnotatedResourceEntry;
import io.crnk.legacy.registry.DefaultResourceInformationProviderContext;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import io.crnk.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.crnk.legacy.repository.annotations.JsonApiResourceRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleRegistry {
    private TypeParser typeParser = new TypeParser();
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private List<Module> modules = new ArrayList<Module>();
    private SimpleModule aggregatedModule = new SimpleModule(null);
    private volatile InitializedState initializedState = InitializedState.NOT_INITIALIZED;
    private ResourceInformationProvider resourceInformationProvider;
    private ServiceDiscovery serviceDiscovery;
    private boolean isServer = true;
    private ExceptionMapperRegistry exceptionMapperRegistry;
    private RequestDispatcher requestDispatcher;
    private HttpRequestContextProvider httpRequestContextProvider = new HttpRequestContextProvider();
    private PropertiesProvider propertiesProvider = new NullPropertiesProvider();
    private ResourceFilterDirectory filterBehaviorProvider;
    private MultivaluedMap<Module, ModuleExtension> extensionMap = new MultivaluedMap();

    public DefaultInformationBuilder getInformationBuilder() {
        return new DefaultInformationBuilder(this.typeParser);
    }

    public List<ResourceModificationFilter> getResourceModificationFilters() {
        return ModuleRegistry.prioritze(this.aggregatedModule.getResourceModificationFilters());
    }

    public ModuleRegistry() {
        this(true);
    }

    public ModuleRegistry(boolean isServer) {
        this.isServer = isServer;
    }

    public void addModule(Module module) {
        module.setupModule(new ModuleContextImpl(module));
        this.modules.add(module);
    }

    public ResourceRegistry getResourceRegistry() {
        if (this.resourceRegistry == null) {
            throw new IllegalStateException("resourceRegistry not yet available");
        }
        return this.resourceRegistry;
    }

    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    public void setRequestDispatcher(RequestDispatcher requestDispatcher) {
        this.requestDispatcher = requestDispatcher;
    }

    public List<com.fasterxml.jackson.databind.Module> getJacksonModules() {
        return this.aggregatedModule.getJacksonModules();
    }

    protected void checkState(InitializedState minState, InitializedState maxState) {
        PreconditionUtil.verify(this.initializedState.ordinal() >= minState.ordinal(), "not yet initialized, cannot yet be called", new Object[0]);
        PreconditionUtil.verify(this.initializedState.ordinal() <= maxState.ordinal(), "already initialized, cannot be called anymore", new Object[0]);
    }

    public ResourceInformationProvider getResourceInformationBuilder() {
        if (this.resourceInformationProvider == null) {
            this.resourceInformationProvider = new CombinedResourceInformationProvider(this.aggregatedModule.getResourceInformationProviders());
            DefaultInformationBuilder informationBuilder = new DefaultInformationBuilder(this.typeParser);
            DefaultResourceInformationProviderContext context = new DefaultResourceInformationProviderContext(this.resourceInformationProvider, informationBuilder, this.typeParser, this.objectMapper);
            this.resourceInformationProvider.init(context);
        }
        return this.resourceInformationProvider;
    }

    public RepositoryInformationProvider getRepositoryInformationBuilder() {
        return new CombinedRepositoryInformationProvider(this.aggregatedModule.getRepositoryInformationProviders());
    }

    public ResourceLookup getResourceLookup() {
        this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
        return new MultiResourceLookup(this.aggregatedModule.getResourceLookups());
    }

    public List<HttpRequestProcessor> getHttpRequestProcessors() {
        this.checkState(InitializedState.INITIALIZED, InitializedState.INITIALIZED);
        return this.aggregatedModule.getHttpRequestProcessors();
    }

    public SecurityProvider getSecurityProvider() {
        this.checkState(InitializedState.INITIALIZED, InitializedState.INITIALIZED);
        List<SecurityProvider> securityProviders = this.aggregatedModule.getSecurityProviders();
        PreconditionUtil.assertEquals("exactly one security provide must be installed, got: " + securityProviders, 1, securityProviders.size());
        return securityProviders.get(0);
    }

    public ServiceDiscovery getServiceDiscovery() {
        PreconditionUtil.assertNotNull("serviceDiscovery not yet available", this.serviceDiscovery);
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
    }

    public void init(ObjectMapper objectMapper) {
        PreconditionUtil.assertEquals("already initialized", (Object)InitializedState.NOT_INITIALIZED, (Object)this.initializedState);
        this.initializedState = InitializedState.INITIALIZING;
        this.objectMapper = objectMapper;
        this.objectMapper.registerModules(this.getJacksonModules());
        this.initializeModules();
        this.applyRepositoryRegistrations(this.resourceRegistry);
        ExceptionMapperLookup exceptionMapperLookup = this.getExceptionMapperLookup();
        ExceptionMapperRegistryBuilder mapperRegistryBuilder = new ExceptionMapperRegistryBuilder();
        this.exceptionMapperRegistry = mapperRegistryBuilder.build(exceptionMapperLookup);
        this.filterBehaviorProvider = new ResourceFilterDirectoryImpl(this.aggregatedModule.getResourceFilters(), this.httpRequestContextProvider, this.resourceRegistry);
        this.initializedState = InitializedState.INITIALIZED;
    }

    private void initializeModules() {
        this.setExtensions();
        HashSet<Module> initializedModules = new HashSet<Module>();
        for (Module module : this.modules) {
            this.initializeModule(module, initializedModules);
        }
    }

    private void setExtensions() {
        MultivaluedMap<Module, ModuleExtension> reverseExtensionMap = new MultivaluedMap<Module, ModuleExtension>();
        for (ModuleExtension extension : this.aggregatedModule.getExtensions()) {
            Optional<? extends Module> optModule = this.getModule(extension.getTargetModule());
            if (optModule.isPresent()) {
                reverseExtensionMap.add(optModule.get(), extension);
                continue;
            }
            if (extension.isOptional()) continue;
            throw new IllegalStateException(extension.getTargetModule() + " not installed but required by " + extension);
        }
        for (Module extendedModule : reverseExtensionMap.keySet()) {
            List extensions = reverseExtensionMap.getList(extendedModule);
            PreconditionUtil.assertTrue("module must extend ModuleExtensionAware", extendedModule instanceof ModuleExtensionAware);
            ((ModuleExtensionAware)extendedModule).setExtensions(extensions);
        }
    }

    private void initializeModule(Module module, HashSet<Module> initializedModules) {
        if (!initializedModules.contains(module)) {
            initializedModules.add(module);
            if (this.extensionMap.containsKey(module)) {
                List<ModuleExtension> dependencies = this.extensionMap.getList(module);
                for (ModuleExtension dependencyExtension : dependencies) {
                    Optional<? extends Module> dependencyModule = this.getModule(dependencyExtension.getTargetModule());
                    PreconditionUtil.assertTrue("module dependency not available", dependencyModule.isPresent() || dependencyExtension.isOptional());
                    if (!dependencyModule.isPresent()) continue;
                    this.initializeModule(dependencyModule.get(), initializedModules);
                }
            }
            if (module instanceof InitializingModule) {
                ((InitializingModule)module).init();
            }
        }
    }

    public HttpRequestContextProvider getHttpRequestContextProvider() {
        return this.httpRequestContextProvider;
    }

    private void applyRepositoryRegistrations(ResourceRegistry resourceRegistry) {
        List<Object> repositories = this.aggregatedModule.getRepositories();
        MultivaluedMap<String, RepositoryInformation> typeInfoMapping = new MultivaluedMap<String, RepositoryInformation>();
        HashMap<Object, Object> infoRepositoryMapping = new HashMap<Object, Object>();
        this.mapRepositoryRegistrations(repositories, typeInfoMapping, infoRepositoryMapping);
        for (String resourceType : typeInfoMapping.keySet()) {
            this.applyRepositoryRegistration(resourceType, typeInfoMapping, infoRepositoryMapping);
        }
    }

    private void applyRepositoryRegistration(String resourceType, MultivaluedMap<String, RepositoryInformation> typeInfoMapping, Map<Object, Object> infoRepositoryMapping) {
        ResourceInformation resourceInformation = null;
        ResourceRepositoryInformation resourceRepositoryInformation = null;
        ArrayList<ResponseRelationshipEntry> relationshipEntries = new ArrayList<ResponseRelationshipEntry>();
        ResourceEntry resourceEntry = null;
        Class resourceClass = null;
        List<RepositoryInformation> repositoryInformations = typeInfoMapping.getList(resourceType);
        ArrayList<Object> unwrappedRelationshipRepositories = new ArrayList<Object>();
        for (RepositoryInformation repositoryInformation : repositoryInformations) {
            if (repositoryInformation instanceof ResourceRepositoryInformation) {
                resourceRepositoryInformation = (ResourceRepositoryInformation)repositoryInformation;
                Object repository = infoRepositoryMapping.get(resourceRepositoryInformation);
                resourceEntry = this.setupResourceRepository(repository);
                continue;
            }
            RelationshipRepositoryInformation relationshipRepositoryInformation = (RelationshipRepositoryInformation)repositoryInformation;
            Object repository = infoRepositoryMapping.get(repositoryInformation);
            unwrappedRelationshipRepositories.add(repository);
            this.setupRelationship(relationshipEntries, relationshipRepositoryInformation, repository);
            if (resourceClass != null) continue;
            resourceClass = relationshipRepositoryInformation.getSourceResourceClass().get();
        }
        if (resourceRepositoryInformation != null) {
            resourceInformation = resourceRepositoryInformation.getResourceInformation().get();
        }
        if (resourceInformation == null) {
            ResourceInformationProvider resourceInformationProvider = this.getResourceInformationBuilder();
            PreconditionUtil.assertNotNull("resource class cannot be determined", resourceClass);
            resourceInformation = resourceInformationProvider.build(resourceClass);
        }
        this.contributeFields(resourceInformation, unwrappedRelationshipRepositories);
        RegistryEntry registryEntry = new RegistryEntry(resourceInformation, resourceRepositoryInformation, resourceEntry, relationshipEntries);
        registryEntry.initialize(this);
        this.resourceRegistry.addEntry(registryEntry);
    }

    private void contributeFields(ResourceInformation resourceInformation, List<Object> unwrappedRelationshipRepositories) {
        for (Object relRepository : unwrappedRelationshipRepositories) {
            if (!(relRepository instanceof ResourceFieldContributor)) continue;
            ResourceFieldContributor contributor = (ResourceFieldContributor)relRepository;
            List<ResourceField> contributedFields = contributor.getResourceFields(new ResourceFieldContributorContext(){

                @Override
                public InformationBuilder getInformationBuilder() {
                    return new DefaultInformationBuilder(ModuleRegistry.this.typeParser);
                }
            });
            ArrayList<ResourceField> fields = new ArrayList<ResourceField>();
            fields.addAll(resourceInformation.getFields());
            fields.addAll(contributedFields);
            resourceInformation.setFields(fields);
        }
    }

    private void mapRepositoryRegistrations(List<Object> repositories, MultivaluedMap<String, RepositoryInformation> resourceTypeMap, Map<Object, Object> resourceInformationMap) {
        RepositoryInformationProvider repositoryInformationProvider = this.getRepositoryInformationBuilder();
        DefaultRepositoryInformationProviderContext builderContext = new DefaultRepositoryInformationProviderContext(this);
        for (Object repository : repositories) {
            RepositoryInformation info;
            if (repository instanceof ResourceRepositoryDecorator || repository instanceof RelationshipRepositoryDecorator) continue;
            RepositoryInformation repositoryInformation = repositoryInformationProvider.build(repository, (RepositoryInformationProviderContext)builderContext);
            if (repositoryInformation instanceof ResourceRepositoryInformation) {
                info = (ResourceRepositoryInformation)repositoryInformation;
                resourceInformationMap.put(info, repository);
                resourceTypeMap.add(info.getResourceType(), repositoryInformation);
                continue;
            }
            info = (RelationshipRepositoryInformation)repositoryInformation;
            resourceInformationMap.put(info, repository);
            resourceTypeMap.add(info.getSourceResourceType(), repositoryInformation);
        }
    }

    private ResourceEntry setupResourceRepository(Object repository) {
        final Object decoratedRepository = this.decorateRepository(repository);
        RepositoryInstanceBuilder repositoryInstanceBuilder = new RepositoryInstanceBuilder(null, repository.getClass()){

            public Object buildRepository() {
                return decoratedRepository;
            }
        };
        if (ClassUtils.getAnnotation(decoratedRepository.getClass(), JsonApiResourceRepository.class).isPresent()) {
            return new AnnotatedResourceEntry(repositoryInstanceBuilder);
        }
        return new DirectResponseResourceEntry(repositoryInstanceBuilder);
    }

    public Object decorateRepository(Object repository) {
        Decorator decoratedRepository = repository;
        List<RepositoryDecoratorFactory> repositoryDecorators = this.getRepositoryDecoratorFactories();
        for (RepositoryDecoratorFactory repositoryDecorator : repositoryDecorators) {
            Decorator decorator = null;
            if (decoratedRepository instanceof RelationshipRepositoryV2) {
                decorator = repositoryDecorator.decorateRepository(decoratedRepository);
            } else if (decoratedRepository instanceof ResourceRepositoryV2) {
                decorator = repositoryDecorator.decorateRepository((ResourceRepositoryV2)((Object)decoratedRepository));
            }
            if (decorator == null) continue;
            decorator.setDecoratedObject(decoratedRepository);
            decoratedRepository = decorator;
        }
        if (decoratedRepository instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)((Object)decoratedRepository)).setResourceRegistry(this.resourceRegistry);
        }
        return decoratedRepository;
    }

    private void setupRelationship(List<ResponseRelationshipEntry> relationshipEntries, RelationshipRepositoryInformation relationshipRepositoryInformation, Object relRepository) {
        final Object decoratedRepository = this.decorateRepository(relRepository);
        RepositoryInstanceBuilder<Object> relationshipInstanceBuilder = new RepositoryInstanceBuilder<Object>(null, relRepository.getClass()){

            @Override
            public Object buildRepository() {
                return decoratedRepository;
            }
        };
        final String targetResourceType = relationshipRepositoryInformation.getTargetResourceType();
        if (ClassUtils.getAnnotation(relRepository.getClass(), JsonApiRelationshipRepository.class).isPresent()) {
            relationshipEntries.add(new AnnotatedRelationshipEntryBuilder(this, relationshipInstanceBuilder));
        } else {
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry(relationshipInstanceBuilder){

                @Override
                public String getTargetResourceType() {
                    return targetResourceType;
                }
            };
            relationshipEntries.add(relationshipEntry);
        }
    }

    public List<DocumentFilter> getFilters() {
        return ModuleRegistry.prioritze(this.aggregatedModule.getFilters());
    }

    public List<RepositoryFilter> getRepositoryFilters() {
        return ModuleRegistry.prioritze(this.aggregatedModule.getRepositoryFilters());
    }

    public List<RepositoryDecoratorFactory> getRepositoryDecoratorFactories() {
        return this.aggregatedModule.getRepositoryDecoratorFactories();
    }

    public ExceptionMapperLookup getExceptionMapperLookup() {
        return new CombinedExceptionMapperLookup(this.aggregatedModule.getExceptionMapperLookups());
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public <T extends Module> Optional<T> getModule(Class<T> clazz) {
        for (Module module : this.modules) {
            if (!clazz.isInstance(module)) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    public TypeParser getTypeParser() {
        return this.typeParser;
    }

    public Module.ModuleContext getContext() {
        return new ModuleContextImpl(null);
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        PreconditionUtil.assertNotNull("exceptionMapperRegistry not set", this.exceptionMapperRegistry);
        return this.exceptionMapperRegistry;
    }

    public Map<String, ResourceRegistryPart> getRegistryParts() {
        return this.aggregatedModule.getRegistryParts();
    }

    public List<RegistryEntry> getRegistryEntries() {
        return this.aggregatedModule.getRegistryEntries();
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private static <T> List<T> prioritze(List<T> list) {
        ArrayList<T> results = new ArrayList<T>(list);
        Collections.sort(results, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int p1 = this.getPriority(o1);
                int p2 = this.getPriority(o2);
                return p1 - p2;
            }

            private int getPriority(T o1) {
                if (o1 instanceof Prioritizable) {
                    return ((Prioritizable)o1).getPriority();
                }
                return 0;
            }
        });
        return results;
    }

    class ModuleContextImpl
    implements Module.ModuleContext {
        private final Module module;

        public ModuleContextImpl(Module module) {
            this.module = module;
        }

        @Override
        public void addResourceInformationBuilder(ResourceInformationProvider resourceInformationProvider) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addResourceInformationProvider(resourceInformationProvider);
        }

        @Override
        public void addRepositoryInformationBuilder(RepositoryInformationProvider repositoryInformationProvider) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addRepositoryInformationBuilder(repositoryInformationProvider);
        }

        @Override
        public void addResourceLookup(ResourceLookup resourceLookup) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addResourceLookup(resourceLookup);
        }

        @Override
        public void addJacksonModule(com.fasterxml.jackson.databind.Module module) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addJacksonModule(module);
        }

        @Override
        public ResourceRegistry getResourceRegistry() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            if (ModuleRegistry.this.resourceRegistry == null) {
                throw new IllegalStateException("resourceRegistry not yet available");
            }
            return ModuleRegistry.this.resourceRegistry;
        }

        @Override
        public void addFilter(DocumentFilter filter) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addFilter(filter);
        }

        @Override
        public void addExceptionMapperLookup(ExceptionMapperLookup exceptionMapperLookup) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addExceptionMapperLookup(exceptionMapperLookup);
        }

        @Override
        public void addExceptionMapper(ExceptionMapper<?> exceptionMapper) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addExceptionMapper(exceptionMapper);
        }

        @Override
        public void addRepository(Class<?> type, Object repository) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.INITIALIZING);
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public void addRepository(Class<?> sourceType, Class<?> targetType, Object repository) {
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public void addSecurityProvider(SecurityProvider securityProvider) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addSecurityProvider(securityProvider);
        }

        @Override
        public SecurityProvider getSecurityProvider() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.getSecurityProvider();
        }

        @Override
        public void addExtension(ModuleExtension extension) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addExtension(extension);
            ModuleRegistry.this.extensionMap.add(this.module, extension);
        }

        @Override
        public void addHttpRequestProcessor(HttpRequestProcessor processor) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addHttpRequestProcessor(processor);
        }

        @Override
        public ObjectMapper getObjectMapper() {
            PreconditionUtil.assertNotNull("objectMapper is null", ModuleRegistry.this.objectMapper);
            return ModuleRegistry.this.objectMapper;
        }

        @Override
        public void addRegistryPart(String prefix, ResourceRegistryPart part) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addRegistryPart(prefix, part);
        }

        @Override
        public ServiceDiscovery getServiceDiscovery() {
            return ModuleRegistry.this.getServiceDiscovery();
        }

        @Override
        public void addRepositoryFilter(RepositoryFilter filter) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addRepositoryFilter(filter);
        }

        @Override
        public void addResourceFilter(ResourceFilter filter) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addResourceFilter(filter);
        }

        @Override
        public void addRepositoryDecoratorFactory(RepositoryDecoratorFactory decoratorFactory) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addRepositoryDecoratorFactory(decoratorFactory);
        }

        @Override
        public void addRepository(Object repository) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.INITIALIZING);
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public boolean isServer() {
            return ModuleRegistry.this.isServer;
        }

        @Override
        public TypeParser getTypeParser() {
            return ModuleRegistry.this.typeParser;
        }

        @Override
        public ResourceInformationProvider getResourceInformationBuilder() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.getResourceInformationBuilder();
        }

        @Override
        public ExceptionMapperRegistry getExceptionMapperRegistry() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.getExceptionMapperRegistry();
        }

        @Override
        public RequestDispatcher getRequestDispatcher() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.requestDispatcher;
        }

        @Override
        public RegistryEntryBuilder newRegistryEntryBuilder() {
            return new DefaultRegistryEntryBuilder(ModuleRegistry.this);
        }

        @Override
        public void addRegistryEntry(RegistryEntry entry) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.INITIALIZING);
            ModuleRegistry.this.aggregatedModule.addRegistryEntry(entry);
        }

        @Override
        public ResourceFilterDirectory getResourceFilterDirectory() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.filterBehaviorProvider;
        }

        @Override
        public void addResourceModificationFilter(ResourceModificationFilter filter) {
            ModuleRegistry.this.aggregatedModule.addResourceModificationFilter(filter);
        }

        @Override
        public PropertiesProvider getPropertiesProvider() {
            return ModuleRegistry.this.propertiesProvider;
        }
    }

    static class CombinedExceptionMapperLookup
    implements ExceptionMapperLookup {
        private Collection<ExceptionMapperLookup> lookups;

        public CombinedExceptionMapperLookup(List<ExceptionMapperLookup> lookups) {
            this.lookups = lookups;
        }

        @Override
        public Set<JsonApiExceptionMapper> getExceptionMappers() {
            HashSet<JsonApiExceptionMapper> set = new HashSet<JsonApiExceptionMapper>();
            for (ExceptionMapperLookup lookup : this.lookups) {
                set.addAll(lookup.getExceptionMappers());
            }
            return set;
        }
    }

    static class CombinedRepositoryInformationProvider
    implements RepositoryInformationProvider {
        private Collection<RepositoryInformationProvider> builders;

        public CombinedRepositoryInformationProvider(List<RepositoryInformationProvider> builders) {
            this.builders = builders;
        }

        @Override
        public boolean accept(Object repository) {
            for (RepositoryInformationProvider builder : this.builders) {
                if (!builder.accept(repository)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RepositoryInformation build(Object repository, RepositoryInformationProviderContext context) {
            for (RepositoryInformationProvider builder : this.builders) {
                if (!builder.accept(repository)) continue;
                return builder.build(repository, context);
            }
            throw new UnsupportedOperationException("no RepositoryInformationProvider available for " + repository.getClass().getName());
        }

        @Override
        public boolean accept(Class<?> repositoryClass) {
            for (RepositoryInformationProvider builder : this.builders) {
                if (!builder.accept(repositoryClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RepositoryInformation build(Class<?> repositoryClass, RepositoryInformationProviderContext context) {
            for (RepositoryInformationProvider builder : this.builders) {
                if (!builder.accept(repositoryClass)) continue;
                return builder.build(repositoryClass, context);
            }
            throw new UnsupportedOperationException("no RepositoryInformationProvider available for " + repositoryClass.getName());
        }
    }

    static class CombinedResourceInformationProvider
    implements ResourceInformationProvider {
        private Collection<ResourceInformationProvider> builders;

        public CombinedResourceInformationProvider(List<ResourceInformationProvider> builders) {
            this.builders = builders;
        }

        @Override
        public boolean accept(Class<?> resourceClass) {
            for (ResourceInformationProvider builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ResourceInformation build(Class<?> resourceClass) {
            for (ResourceInformationProvider builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.build(resourceClass);
            }
            throw new UnsupportedOperationException("no ResourceInformationProvider available for " + resourceClass.getName());
        }

        @Override
        public String getResourceType(Class<?> resourceClass) {
            for (ResourceInformationProvider builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.getResourceType(resourceClass);
            }
            return null;
        }

        @Override
        public void init(ResourceInformationProviderContext context) {
            for (ResourceInformationProvider builder : this.builders) {
                builder.init(context);
            }
        }
    }

    static enum InitializedState {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

