/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.util.List;
import java.util.Set;

public class ResourcePost
extends ResourceUpsert {
    public ResourcePost(ResourceRegistry resourceRegistry, PropertiesProvider propertiesProvider, TypeParser typeParser, ObjectMapper objectMapper, DocumentMapper documentMapper, List<ResourceModificationFilter> modificationFilters) {
        super(resourceRegistry, propertiesProvider, typeParser, objectMapper, documentMapper, modificationFilters);
    }

    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String requestType) {
        return jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.POST.name().equals(requestType);
    }

    @Override
    public Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestDocument) {
        JsonApiResponse apiResponse;
        RegistryEntry endpointRegistryEntry = this.getRegistryEntry(jsonPath);
        Resource resourceBody = this.getRequestBody(requestDocument, jsonPath, HttpMethod.POST);
        RegistryEntry bodyRegistryEntry = this.resourceRegistry.getEntry(resourceBody.getType());
        this.verifyTypes(HttpMethod.POST, endpointRegistryEntry, bodyRegistryEntry);
        ResourceRepositoryAdapter resourceRepository = endpointRegistryEntry.getResourceRepository(parameterProvider);
        if (Resource.class.equals(resourceRepository.getResourceClass())) {
            apiResponse = resourceRepository.create(resourceBody, queryAdapter);
        } else {
            Object newResource = this.newResource(bodyRegistryEntry.getResourceInformation(), resourceBody);
            this.setId(resourceBody, newResource, bodyRegistryEntry.getResourceInformation());
            this.setAttributes(resourceBody, newResource, bodyRegistryEntry.getResourceInformation());
            this.setRelations(newResource, bodyRegistryEntry, resourceBody, queryAdapter, parameterProvider, false);
            apiResponse = resourceRepository.create(newResource, queryAdapter);
        }
        if (apiResponse.getEntity() == null) {
            throw new IllegalStateException("repository did not return the created resource");
        }
        Set<String> loadedRelationshipNames = this.getLoadedRelationshipNames(resourceBody);
        Document responseDocument = this.documentMapper.toDocument(apiResponse, queryAdapter, parameterProvider, loadedRelationshipNames);
        return new Response(responseDocument, 201);
    }
}

