/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.path;

import io.crnk.core.engine.internal.dispatcher.path.PathIds;
import io.crnk.core.engine.internal.utils.CompareUtils;
import java.util.Objects;

public abstract class JsonPath {
    final String elementName;
    PathIds ids;
    JsonPath parentResource;

    public JsonPath(String elementName) {
        this(elementName, null);
    }

    public JsonPath(String elementName, PathIds pathIds) {
        this.elementName = elementName;
        this.ids = pathIds;
    }

    public abstract boolean isCollection();

    public abstract String getResourceType();

    public String getElementName() {
        return this.elementName;
    }

    public PathIds getIds() {
        return this.ids;
    }

    public void setIds(PathIds ids) {
        this.ids = ids;
    }

    public JsonPath getParentResource() {
        return this.parentResource;
    }

    public void setParentResource(JsonPath parentResource) {
        this.parentResource = parentResource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPath jsonPath = (JsonPath)o;
        return CompareUtils.isEquals(this.elementName, jsonPath.elementName) && CompareUtils.isEquals(this.ids, jsonPath.ids) && CompareUtils.isEquals(this.parentResource, jsonPath.parentResource);
    }

    public int hashCode() {
        return Objects.hash(this.elementName, this.ids, this.parentResource);
    }
}

