package io.crnk.core.engine.information;

import io.crnk.core.engine.internal.information.DefaultInformationBuilder;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import java.lang.reflect.Type;

import io.crnk.core.engine.information.repository.RelationshipRepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryMethodAccess;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.SerializeType;

public interface InformationBuilder {

	Field createResourceField();

	interface RelationshipRepository {

		void setAccess(RepositoryMethodAccess access);

		RelationshipRepositoryInformation build();

	}

	interface ResourceRepository {

		void setResourceInformation(ResourceInformation resourceInformation);

		void setAccess(RepositoryMethodAccess access);

		ResourceRepositoryInformation build();

	}

	interface Resource {

		InformationBuilder.Field addField(String name, ResourceFieldType id1, Class<?> clazz);

		Resource resourceClass(Class<?> resourceClass);

		Resource resourceType(String resourceType);

		Resource superResourceType(String superResourceType);

		ResourceInformation build();

	}

	interface Field {

		ResourceField build();

		Field relationshipRepositoryBehavior(
				RelationshipRepositoryBehavior relationshipRepositoryBehavior);

		Field jsonName(String jsonName);

		Field underlyingName(String underlyingName);

		Field name(String name);

		Field type(Class<?> type);

		Field genericType(Type genericType);

		Field serializeType(SerializeType serializeType);

		Field oppositeResourceType(String oppositeResourceType);

		Field lookupIncludeBehavior(LookupIncludeBehavior lookupIncludeBehavior);

		Field fieldType(ResourceFieldType fieldType);

		Field oppositeName(String oppositeName);

		Field accessor(ResourceFieldAccessor accessor);

		Field access(ResourceFieldAccess access);

		Field idAccessor(ResourceFieldAccessor idAccessor);

		Field idName(String idName);

		Field idType(Class idType);

	}

	RelationshipRepository createRelationshipRepository(String sourceResourceType, String targeResourceType);

	ResourceRepository createResourceRepository();

	Resource createResource(Class<?> resourceClass, String resourceType);

}
