/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher;

import io.crnk.core.engine.internal.dispatcher.controller.BaseController;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathBuilder;
import io.crnk.core.exception.MethodNotFoundException;
import java.util.LinkedList;
import java.util.List;

public class ControllerRegistry {
    private final List<BaseController> controllers = new LinkedList<BaseController>();

    public ControllerRegistry(List<BaseController> baseControllers) {
        if (baseControllers != null) {
            this.controllers.addAll(baseControllers);
        }
    }

    public void addController(BaseController controller) {
        this.controllers.add(controller);
    }

    public BaseController getController(JsonPath jsonPath, String requestType) {
        for (BaseController controller : this.controllers) {
            if (!controller.isAcceptable(jsonPath, requestType)) continue;
            return controller;
        }
        throw new MethodNotFoundException(PathBuilder.build(jsonPath), requestType);
    }
}

