/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.internal.dispatcher.ControllerLookup;
import io.crnk.core.engine.internal.dispatcher.controller.BaseController;
import io.crnk.core.engine.internal.dispatcher.controller.CollectionGet;
import io.crnk.core.engine.internal.dispatcher.controller.FieldResourceGet;
import io.crnk.core.engine.internal.dispatcher.controller.FieldResourcePost;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourceDelete;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourceGet;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourcePatch;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourcePost;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceDelete;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceGet;
import io.crnk.core.engine.internal.dispatcher.controller.ResourcePatch;
import io.crnk.core.engine.internal.dispatcher.controller.ResourcePost;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.ResourceRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultControllerLookup
implements ControllerLookup {
    private final List<ResourceModificationFilter> modificationFilters;
    private final ResourceRegistry resourceRegistry;
    private final TypeParser typeParser;
    private final ObjectMapper objectMapper;
    private final DocumentMapper documentMapper;
    private final PropertiesProvider propertiesProvider;

    public DefaultControllerLookup(ResourceRegistry resourceRegistry, PropertiesProvider propertiesProvider, TypeParser typeParser, ObjectMapper objectMapper, DocumentMapper documentMapper, List<ResourceModificationFilter> modificationFilters) {
        this.resourceRegistry = resourceRegistry;
        this.propertiesProvider = propertiesProvider;
        this.typeParser = typeParser;
        this.objectMapper = objectMapper;
        this.documentMapper = documentMapper;
        this.modificationFilters = modificationFilters;
    }

    @Override
    public Set<BaseController> getControllers() {
        HashSet<BaseController> controllers = new HashSet<BaseController>();
        controllers.add(new RelationshipsResourceDelete(this.resourceRegistry, this.typeParser, this.modificationFilters));
        controllers.add(new RelationshipsResourcePatch(this.resourceRegistry, this.typeParser, this.modificationFilters));
        controllers.add(new RelationshipsResourcePost(this.resourceRegistry, this.typeParser, this.modificationFilters));
        controllers.add(new ResourceDelete(this.resourceRegistry, this.modificationFilters));
        controllers.add(new CollectionGet(this.resourceRegistry, this.typeParser, this.documentMapper));
        controllers.add(new FieldResourceGet(this.resourceRegistry, this.typeParser, this.documentMapper));
        controllers.add(new RelationshipsResourceGet(this.resourceRegistry, this.typeParser, this.documentMapper));
        controllers.add(new ResourceGet(this.resourceRegistry, this.typeParser, this.documentMapper));
        controllers.add(new FieldResourcePost(this.resourceRegistry, this.propertiesProvider, this.typeParser, this.objectMapper, this.documentMapper, this.modificationFilters));
        controllers.add(new ResourcePatch(this.resourceRegistry, this.propertiesProvider, this.typeParser, this.objectMapper, this.documentMapper, this.modificationFilters));
        controllers.add(new ResourcePost(this.resourceRegistry, this.propertiesProvider, this.typeParser, this.objectMapper, this.documentMapper, this.modificationFilters));
        return controllers;
    }
}

