/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.http;

import io.crnk.core.engine.dispatcher.RequestDispatcher;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.DocumentFilterChain;
import io.crnk.core.engine.filter.DocumentFilterContext;
import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.dispatcher.controller.BaseController;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathBuilder;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.http.HttpRequestContextBaseAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.utils.Optional;
import io.crnk.legacy.internal.QueryParamsAdapter;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import io.crnk.legacy.queryParams.QueryParams;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestProcessorImpl
implements RequestDispatcher {
    private final ControllerRegistry controllerRegistry;
    private final ExceptionMapperRegistry exceptionMapperRegistry;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ModuleRegistry moduleRegistry;
    private QueryAdapterBuilder queryAdapterBuilder;

    public HttpRequestProcessorImpl(ModuleRegistry moduleRegistry, ControllerRegistry controllerRegistry, ExceptionMapperRegistry exceptionMapperRegistry, QueryAdapterBuilder queryAdapterBuilder) {
        this.controllerRegistry = controllerRegistry;
        this.moduleRegistry = moduleRegistry;
        this.exceptionMapperRegistry = exceptionMapperRegistry;
        this.queryAdapterBuilder = queryAdapterBuilder;
        this.moduleRegistry.setRequestDispatcher(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HttpRequestContextBase requestContextBase) throws IOException {
        HttpRequestContextBaseAdapter requestContext = new HttpRequestContextBaseAdapter(requestContextBase);
        HttpRequestContextProvider httpRequestContextProvider = this.moduleRegistry.getHttpRequestContextProvider();
        try {
            httpRequestContextProvider.onRequestStarted(requestContext);
            List<HttpRequestProcessor> processors = this.moduleRegistry.getHttpRequestProcessors();
            PreconditionUtil.assertFalse("no processors available", processors.isEmpty());
            for (HttpRequestProcessor processor : processors) {
                processor.process(requestContext);
                if (!requestContext.hasResponse()) continue;
                break;
            }
        }
        finally {
            httpRequestContextProvider.onRequestFinished();
        }
    }

    @Override
    public Response dispatchRequest(String path, String method, Map<String, Set<String>> parameters, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        JsonPath jsonPath = new PathBuilder(this.moduleRegistry.getResourceRegistry()).build(path);
        try {
            BaseController controller = this.controllerRegistry.getController(jsonPath, method);
            ResourceInformation resourceInformation = this.getRequestedResource(jsonPath);
            QueryAdapter queryAdapter = this.queryAdapterBuilder.build(resourceInformation, parameters);
            DefaultFilterRequestContext context = new DefaultFilterRequestContext(jsonPath, queryAdapter, parameterProvider, requestBody, method);
            DefaultFilterChain chain = new DefaultFilterChain(controller);
            return chain.doFilter(context);
        }
        catch (Exception e) {
            Optional<JsonApiExceptionMapper> exceptionMapper = this.exceptionMapperRegistry.findMapperFor(e.getClass());
            if (exceptionMapper.isPresent()) {
                this.logger.debug("dispatching exception to mapper", (Throwable)e);
                return exceptionMapper.get().toErrorResponse(e).toResponse();
            }
            this.logger.error("failed to process request", (Throwable)e);
            throw e;
        }
    }

    private ResourceInformation getRequestedResource(JsonPath jsonPath) {
        ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
        RegistryEntry registryEntry = resourceRegistry.getEntry(jsonPath.getResourceType());
        PreconditionUtil.assertNotNull("repository not found, that should have been catched earlier", registryEntry);
        String elementName = jsonPath.getElementName();
        if (elementName != null && !elementName.equals(jsonPath.getResourceType())) {
            ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(elementName);
            if (relationshipField == null) {
                throw new ResourceFieldNotFoundException(elementName);
            }
            String oppositeResourceType = relationshipField.getOppositeResourceType();
            return resourceRegistry.getEntry(oppositeResourceType).getResourceInformation();
        }
        return registryEntry.getResourceInformation();
    }

    @Override
    public void dispatchAction(String path, String method, Map<String, Set<String>> parameters) {
        JsonPath jsonPath = new PathBuilder(this.moduleRegistry.getResourceRegistry()).build(path);
        ActionFilterChain chain = new ActionFilterChain();
        DefaultFilterRequestContext context = new DefaultFilterRequestContext(jsonPath, null, null, null, method);
        chain.doFilter(context);
    }

    public QueryAdapterBuilder getQueryAdapterBuilder() {
        return this.queryAdapterBuilder;
    }

    class DefaultFilterRequestContext
    implements DocumentFilterContext {
        protected JsonPath jsonPath;
        protected QueryAdapter queryAdapter;
        protected RepositoryMethodParameterProvider parameterProvider;
        protected Document requestBody;
        private String method;

        public DefaultFilterRequestContext(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody, String method) {
            this.jsonPath = jsonPath;
            this.queryAdapter = queryAdapter;
            this.parameterProvider = parameterProvider;
            this.requestBody = requestBody;
            this.method = method;
        }

        @Override
        public Document getRequestBody() {
            return this.requestBody;
        }

        @Override
        public RepositoryMethodParameterProvider getParameterProvider() {
            return this.parameterProvider;
        }

        @Override
        public QueryParams getQueryParams() {
            return ((QueryParamsAdapter)this.queryAdapter).getQueryParams();
        }

        @Override
        public QueryAdapter getQueryAdapter() {
            return this.queryAdapter;
        }

        @Override
        public JsonPath getJsonPath() {
            return this.jsonPath;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }

    class ActionFilterChain
    implements DocumentFilterChain {
        protected int filterIndex = 0;

        ActionFilterChain() {
        }

        @Override
        public Response doFilter(DocumentFilterContext context) {
            List<DocumentFilter> filters = HttpRequestProcessorImpl.this.moduleRegistry.getFilters();
            if (this.filterIndex == filters.size()) {
                return null;
            }
            DocumentFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filter(context, this);
        }
    }

    class DefaultFilterChain
    implements DocumentFilterChain {
        protected int filterIndex = 0;
        protected BaseController controller;

        public DefaultFilterChain(BaseController controller) {
            this.controller = controller;
        }

        @Override
        public Response doFilter(DocumentFilterContext context) {
            List<DocumentFilter> filters = HttpRequestProcessorImpl.this.moduleRegistry.getFilters();
            if (this.filterIndex == filters.size()) {
                return this.controller.handle(context.getJsonPath(), context.getQueryAdapter(), context.getParameterProvider(), context.getRequestBody());
            }
            DocumentFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filter(context, this);
        }
    }
}

