/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.registry.ResourceRegistryPartBase;
import io.crnk.core.engine.registry.ResourceRegistryPartEvent;
import io.crnk.core.engine.registry.ResourceRegistryPartListener;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.exception.InvalidResourceException;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.utils.Optional;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceRegistryImpl
extends ResourceRegistryPartBase
implements ResourceRegistry {
    private ModuleRegistry moduleRegistry;
    private ConcurrentHashMap<String, ResourceInformation> baseTypeCache = new ConcurrentHashMap();
    private ResourceRegistryPart rootPart;
    private ResourceRegistryPartListener rootListener = new ResourceRegistryPartListener(){

        @Override
        public void onChanged(ResourceRegistryPartEvent event) {
            ResourceRegistryImpl.this.notifyChange();
        }
    };

    public ResourceRegistryImpl(ResourceRegistryPart rootPart, ModuleRegistry moduleRegistry) {
        this.rootPart = rootPart;
        this.moduleRegistry = moduleRegistry;
        this.moduleRegistry.setResourceRegistry(this);
        rootPart.addListener(this.rootListener);
    }

    @Override
    public RegistryEntry addEntry(Class<?> resource, RegistryEntry registryEntry) {
        return this.addEntry(registryEntry);
    }

    protected RegistryEntry findEntry(Class<?> clazz, boolean allowNull) {
        Optional<Class<?>> resourceClazz = this.getResourceClass(clazz);
        if (allowNull && !resourceClazz.isPresent()) {
            return null;
        }
        if (!resourceClazz.isPresent()) {
            throw new RepositoryNotFoundException(clazz.getCanonicalName());
        }
        return this.rootPart.getEntry(resourceClazz.get());
    }

    @Override
    public RegistryEntry findEntry(Class<?> clazz) {
        return this.findEntry(clazz, false);
    }

    public Optional<Class<?>> getResourceClass(Class<?> resourceClass) {
        for (Class<?> currentClass = resourceClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            RegistryEntry entry = this.rootPart.getEntry(currentClass);
            if (entry == null) continue;
            return Optional.of(currentClass);
        }
        return Optional.empty();
    }

    @Override
    public ServiceUrlProvider getServiceUrlProvider() {
        return this.moduleRegistry.getHttpRequestContextProvider().getServiceUrlProvider();
    }

    @Override
    @Deprecated
    public RegistryEntry getEntryForClass(Class<?> resourceClass) {
        return this.getEntry(resourceClass);
    }

    public Optional<Class<?>> getResourceClass(Object resource) {
        return this.getResourceClass(resource.getClass());
    }

    @Override
    public String getResourceUrl(ResourceInformation resourceInformation) {
        String url = UrlUtils.removeTrailingSlash(this.getServiceUrlProvider().getUrl());
        return String.format("%s/%s", url, resourceInformation.getResourceType());
    }

    @Override
    public String getResourceUrl(Object resource) {
        Optional<Class<?>> type = this.getResourceClass(resource);
        if (type.isPresent()) {
            ResourceInformation resourceInformation = this.findEntry(type.get()).getResourceInformation();
            return String.format("%s/%s", this.getResourceUrl(resourceInformation), resourceInformation.getId(resource));
        }
        throw new InvalidResourceException("Not registered resource found: " + resource);
    }

    @Override
    public String getResourceUrl(Class<?> clazz) {
        RegistryEntry registryEntry = this.findEntry(clazz);
        return this.getResourceUrl(registryEntry.getResourceInformation());
    }

    @Override
    public String getResourceUrl(Class<?> clazz, String id) {
        RegistryEntry registryEntry = this.findEntry(clazz);
        return String.format("%s/%s", this.getResourceUrl(registryEntry.getResourceInformation()), id);
    }

    @Override
    public ResourceInformation getBaseResourceInformation(String resourceType) {
        ResourceInformation baseInformation = this.baseTypeCache.get(resourceType);
        if (baseInformation != null) {
            return baseInformation;
        }
        RegistryEntry entry = this.getEntry(resourceType);
        baseInformation = entry.getResourceInformation();
        while (baseInformation.getSuperResourceType() != null) {
            String superResourceType = baseInformation.getSuperResourceType();
            entry = this.getEntry(superResourceType);
            PreconditionUtil.assertNotNull(superResourceType, entry);
            baseInformation = entry.getResourceInformation();
        }
        this.baseTypeCache.put(resourceType, baseInformation);
        return baseInformation;
    }

    @Override
    public RegistryEntry addEntry(RegistryEntry entry) {
        return this.rootPart.addEntry(entry);
    }

    @Override
    public boolean hasEntry(Class<?> clazz) {
        return this.rootPart.hasEntry(clazz);
    }

    @Override
    public boolean hasEntry(String resourceType) {
        return this.rootPart.hasEntry(resourceType);
    }

    @Override
    public RegistryEntry getEntry(String resourceType) {
        return this.rootPart.getEntry(resourceType);
    }

    @Override
    public Collection<RegistryEntry> getResources() {
        return this.rootPart.getResources();
    }

    @Override
    public RegistryEntry getEntry(Class<?> clazz) {
        return this.rootPart.getEntry(clazz);
    }
}

