/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.legacy.internal.DefaultQuerySpecConverter;
import io.crnk.legacy.queryParams.QueryParams;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class RepositoryRequestSpecImpl
implements RepositoryRequestSpec {
    private ResourceField relationshipField;
    private QueryAdapter queryAdapter;
    private Iterable<?> ids;
    private Object entity;
    private ModuleRegistry moduleRegistry;
    private HttpMethod method;

    private RepositoryRequestSpecImpl(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    public static RepositoryRequestSpec forDelete(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter, Serializable id) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.ids = Arrays.asList(id);
        spec.method = HttpMethod.DELETE;
        return spec;
    }

    public static RepositoryRequestSpec forSave(ModuleRegistry moduleRegistry, HttpMethod method, QueryAdapter queryAdapter, Object entity) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.entity = entity;
        spec.method = method;
        return spec;
    }

    public static RepositoryRequestSpec forFindIds(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter, Iterable<?> ids) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.ids = ids;
        spec.method = HttpMethod.GET;
        return spec;
    }

    public static RepositoryRequestSpec forFindAll(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.method = HttpMethod.GET;
        return spec;
    }

    public static RepositoryRequestSpec forFindId(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter, Serializable id) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.ids = Collections.singleton(id);
        spec.method = HttpMethod.GET;
        return spec;
    }

    public static RepositoryRequestSpec forFindTarget(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter, List<?> ids, ResourceField relationshipField) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.ids = ids;
        spec.relationshipField = relationshipField;
        spec.method = HttpMethod.GET;
        PreconditionUtil.assertNotNull("relationshipField is null", relationshipField);
        return spec;
    }

    public static RepositoryRequestSpecImpl forRelation(ModuleRegistry moduleRegistry, HttpMethod method, Object entity, QueryAdapter queryAdapter, Iterable<?> ids, ResourceField relationshipField) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.entity = entity;
        spec.queryAdapter = queryAdapter;
        spec.ids = ids;
        spec.relationshipField = relationshipField;
        spec.method = method;
        PreconditionUtil.assertNotNull("relationshipField is null", relationshipField);
        return spec;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public QueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    @Override
    public ResourceField getRelationshipField() {
        return this.relationshipField;
    }

    @Override
    public QuerySpec getQuerySpec(ResourceInformation targetResourceInformation) {
        if (this.queryAdapter instanceof QuerySpecAdapter) {
            QuerySpec querySpec = ((QuerySpecAdapter)this.queryAdapter).getQuerySpec();
            return querySpec.getOrCreateQuerySpec(targetResourceInformation);
        }
        Class<?> targetResourceClass = targetResourceInformation.getResourceClass();
        QueryParams queryParams = this.getQueryParams();
        DefaultQuerySpecConverter converter = new DefaultQuerySpecConverter(this.moduleRegistry);
        return converter.fromParams(targetResourceClass, queryParams);
    }

    @Override
    public QueryParams getQueryParams() {
        return this.queryAdapter.toQueryParams();
    }

    @Override
    public Serializable getId() {
        Iterator iterator;
        Iterable iterable = this.getIds();
        if (iterable != null && (iterator = iterable.iterator()).hasNext()) {
            return (Serializable)iterator.next();
        }
        return null;
    }

    @Override
    public <T> Iterable<T> getIds() {
        if (this.ids == null && this.entity != null) {
            ResourceInformation resourceInformation = this.queryAdapter.getResourceInformation();
            return Collections.singleton(resourceInformation.getId(this.entity));
        }
        return this.ids;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }
}

