/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.repository.BulkRelationshipRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelationshipRepositoryBase<T, I extends Serializable, D, J extends Serializable>
implements BulkRelationshipRepositoryV2<T, I, D, J>,
ResourceRegistryAware {
    protected ResourceRegistry resourceRegistry;
    private Class<D> targetResourceClass;
    private Class<T> sourceResourceClass;
    private String sourceResourceType;
    private String targetResourceType;

    protected RelationshipRepositoryBase() {
    }

    public RelationshipRepositoryBase(Class<T> sourceResourceClass, Class<D> targetResourceClass) {
        this.sourceResourceClass = sourceResourceClass;
        this.targetResourceClass = targetResourceClass;
    }

    public RelationshipRepositoryBase(String sourceResourceType, String targetResourceType) {
        this.sourceResourceType = sourceResourceType;
        this.targetResourceType = targetResourceType;
    }

    @Override
    public D findOneTarget(I sourceId, String fieldName, QuerySpec querySpec) {
        MultivaluedMap<Serializable, D> map = this.findTargets(Arrays.asList(sourceId), fieldName, querySpec);
        if (map.isEmpty()) {
            return null;
        }
        return map.getUnique((Serializable)sourceId);
    }

    @Override
    public ResourceList<D> findManyTargets(I sourceId, String fieldName, QuerySpec querySpec) {
        MultivaluedMap<Serializable, D> map = this.findTargets(Arrays.asList(sourceId), fieldName, querySpec);
        if (map.isEmpty()) {
            return new DefaultResourceList();
        }
        return (ResourceList)map.getList((Serializable)sourceId);
    }

    @Override
    public void setRelation(T source, J targetId, String fieldName) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceRepositoryAdapter sourceAdapter = sourceEntry.getResourceRepository();
        ResourceInformation sourceInformation = this.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        if (field.hasIdField()) {
            field.getIdAccessor().setValue(source, targetId);
        } else {
            RegistryEntry targetEntry = this.getTargetEntry(field);
            D target = this.getTarget(targetEntry, targetId);
            field.getAccessor().setValue(source, target);
        }
        sourceAdapter.update(source, this.getSaveQueryAdapter(fieldName));
    }

    @Override
    public void setRelations(T source, Iterable<J> targetIds, String fieldName) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceRepositoryAdapter sourceAdapter = sourceEntry.getResourceRepository();
        ResourceInformation sourceInformation = this.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        if (field.hasIdField()) {
            field.getIdAccessor().setValue(source, targetIds);
        } else {
            RegistryEntry targetEntry = this.getTargetEntry(field);
            Iterable<D> targets = this.getTargets(targetEntry, targetIds);
            field.getAccessor().setValue(source, targets);
        }
        sourceAdapter.update(source, this.getSaveQueryAdapter(fieldName));
    }

    @Override
    public void addRelations(T source, Iterable<J> targetIds, String fieldName) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceRepositoryAdapter sourceAdapter = sourceEntry.getResourceRepository();
        ResourceInformation sourceInformation = this.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        if (field.hasIdField()) {
            Collection currentIds = (Collection)field.getIdAccessor().getValue(source);
            currentIds.addAll((Collection)targetIds);
        } else {
            RegistryEntry targetEntry = this.getTargetEntry(field);
            Iterable<D> targets = this.getTargets(targetEntry, targetIds);
            Collection<D> currentTargets = this.getOrCreateCollection(source, fieldName);
            for (D target : targets) {
                currentTargets.add(target);
            }
        }
        sourceAdapter.update(source, this.getSaveQueryAdapter(fieldName));
    }

    @Override
    public void removeRelations(T source, Iterable<J> targetIds, String fieldName) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceRepositoryAdapter sourceAdapter = sourceEntry.getResourceRepository();
        ResourceInformation sourceInformation = this.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        if (field.hasIdField()) {
            Collection currentIds = (Collection)field.getIdAccessor().getValue(source);
            currentIds.removeAll((Collection)targetIds);
        } else {
            RegistryEntry targetEntry = this.getTargetEntry(field);
            Iterable<D> targets = this.getTargets(targetEntry, targetIds);
            Collection<D> currentTargets = this.getOrCreateCollection(source, fieldName);
            for (D target : targets) {
                currentTargets.remove(target);
            }
        }
        sourceAdapter.update(source, this.getSaveQueryAdapter(fieldName));
    }

    protected QueryAdapter getSaveQueryAdapter(String fieldName) {
        QuerySpec querySpec = this.newSourceQuerySpec();
        querySpec.includeRelation(Arrays.asList(fieldName));
        return new QuerySpecAdapter(querySpec, this.resourceRegistry);
    }

    private QuerySpec newSourceQuerySpec() {
        return new QuerySpec(this.sourceResourceClass, this.sourceResourceType);
    }

    private Collection<D> getOrCreateCollection(Object source, String fieldName) {
        AbstractCollection property = PropertyUtils.getProperty(source, fieldName);
        if (property == null) {
            Class<?> propertyClass = PropertyUtils.getPropertyClass(source.getClass(), fieldName);
            boolean isList = List.class.isAssignableFrom(propertyClass);
            property = isList ? new ArrayList() : new HashSet();
            PropertyUtils.setProperty(source, fieldName, property);
        }
        return property;
    }

    @Deprecated
    protected Iterable<D> getTargets(Iterable<J> targetIds) {
        RegistryEntry entry = this.resourceRegistry.getEntry(this.targetResourceClass);
        return this.getTargets(entry, targetIds);
    }

    @Deprecated
    protected D getTargets(J targetId) {
        RegistryEntry entry = this.resourceRegistry.getEntry(this.targetResourceClass);
        return this.getTarget(entry, targetId);
    }

    protected D getTarget(RegistryEntry entry, J targetId) {
        QuerySpecAdapter queryAdapter;
        if (targetId == null) {
            return null;
        }
        ResourceRepositoryAdapter targetAdapter = entry.getResourceRepository();
        Object target = targetAdapter.findOne(targetId, queryAdapter = new QuerySpecAdapter(new QuerySpec(entry.getResourceInformation()), this.resourceRegistry)).getEntity();
        if (target == null) {
            throw new IllegalStateException(targetId + " not found");
        }
        return (D)target;
    }

    protected Iterable<D> getTargets(RegistryEntry entry, Iterable<J> targetIds) {
        ResourceRepositoryAdapter targetAdapter = entry.getResourceRepository();
        QuerySpecAdapter queryAdapter = new QuerySpecAdapter(new QuerySpec(entry.getResourceInformation()), this.resourceRegistry);
        return (Iterable)targetAdapter.findAll(targetIds, queryAdapter).getEntity();
    }

    @Override
    public MultivaluedMap<I, D> findTargets(Iterable<I> sourceIds, String fieldName, QuerySpec querySpec) {
        RegistryEntry sourceEntry = this.resourceRegistry.findEntry(this.sourceResourceClass);
        ResourceInformation sourceInformation = sourceEntry.getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        RegistryEntry targetEntry = this.getTargetEntry(field);
        String oppositeName = this.getOppositeName(fieldName);
        QuerySpec idQuerySpec = querySpec.duplicate();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(oppositeName, sourceInformation.getIdField().getUnderlyingName()), FilterOperator.EQ, sourceIds));
        idQuerySpec.includeRelation(Arrays.asList(oppositeName));
        ResourceRepositoryAdapter targetAdapter = targetEntry.getResourceRepository();
        JsonApiResponse response = targetAdapter.findAll(new QuerySpecAdapter(idQuerySpec, this.resourceRegistry));
        List results = (List)response.getEntity();
        MultivaluedMap bulkResult = new MultivaluedMap<I, D>(){

            @Override
            protected List<D> newList() {
                return new DefaultResourceList();
            }
        };
        HashSet<Serializable> sourceIdSet = new HashSet<Serializable>();
        for (Serializable sourceId : sourceIds) {
            sourceIdSet.add(sourceId);
        }
        for (Object result : results) {
            this.handleTarget(bulkResult, result, sourceIdSet, oppositeName, sourceInformation);
        }
        return bulkResult;
    }

    private void handleTarget(MultivaluedMap<I, D> bulkResult, D result, Set<I> sourceIdSet, String oppositeName, ResourceInformation sourceInformation) {
        Object property = PropertyUtils.getProperty(result, oppositeName);
        if (property == null) {
            throw new IllegalStateException("field " + oppositeName + " is null for " + result + ", make sure to properly implement relationship inclusions");
        }
        if (property instanceof Iterable) {
            for (Object potentialSource : (Iterable)property) {
                Serializable sourceId = (Serializable)sourceInformation.getId(potentialSource);
                if (sourceId == null) {
                    throw new IllegalStateException("id is null for " + potentialSource);
                }
                if (!sourceIdSet.contains(sourceId)) continue;
                bulkResult.add(sourceId, result);
            }
        } else {
            Object source = property;
            Serializable sourceId = (Serializable)sourceInformation.getId(source);
            PreconditionUtil.assertTrue("filtering not properly implemented in resource repository", sourceIdSet.contains(sourceId));
            if (sourceId == null) {
                throw new IllegalStateException("id is null for " + source);
            }
            bulkResult.add(sourceId, result);
        }
    }

    protected String getOppositeName(String fieldName) {
        RegistryEntry entry = this.resourceRegistry.findEntry(this.sourceResourceClass);
        ResourceInformation resourceInformation = entry.getResourceInformation();
        ResourceField field = resourceInformation.findRelationshipFieldByName(fieldName);
        if (field == null) {
            throw new IllegalStateException("field " + this.sourceResourceClass.getSimpleName() + "." + fieldName + " not found");
        }
        String oppositeName = field.getOppositeName();
        if (oppositeName == null) {
            throw new IllegalStateException("no opposite specified for field " + this.sourceResourceClass.getSimpleName() + "." + fieldName);
        }
        return oppositeName;
    }

    protected RegistryEntry getSourceEntry() {
        if (this.sourceResourceType != null) {
            return this.resourceRegistry.getEntry(this.sourceResourceType);
        }
        return this.resourceRegistry.findEntry(this.sourceResourceClass);
    }

    protected RegistryEntry getTargetEntry(ResourceField field) {
        return this.resourceRegistry.getEntry(field.getOppositeResourceType());
    }

    @Override
    public Class<T> getSourceResourceClass() {
        return this.sourceResourceClass;
    }

    @Override
    public Class<D> getTargetResourceClass() {
        if (this.targetResourceClass == null) {
            RegistryEntry targetEntry = this.resourceRegistry.getEntry(this.targetResourceType);
            return targetEntry.getResourceInformation().getResourceClass();
        }
        return this.targetResourceClass;
    }

    @Override
    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }
}

