/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository.implicit;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.repository.RelationshipRepositoryBase;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.DefaultResourceList;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ImplicitOwnerBasedRelationshipRepository<T, I extends Serializable, D, J extends Serializable>
extends RelationshipRepositoryBase<T, I, D, J> {
    protected ImplicitOwnerBasedRelationshipRepository() {
    }

    public ImplicitOwnerBasedRelationshipRepository(Class sourceResourceClass, Class targetResourceClass) {
        super(sourceResourceClass, targetResourceClass);
    }

    public ImplicitOwnerBasedRelationshipRepository(String sourceResourceType, String targetResourceType) {
        super(sourceResourceType, targetResourceType);
    }

    @Override
    public MultivaluedMap<I, D> findTargets(Iterable<I> sourceIds, String fieldName, QuerySpec querySpec) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceInformation sourceInformation = sourceEntry.getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        List sources = (List)sourceEntry.getResourceRepository().findAll(sourceIds, this.getSaveQueryAdapter(fieldName)).getEntity();
        ResourceInformation targetInformation = this.getTargetInformation(field);
        if (field.hasIdField()) {
            HashSet<Object> targetIds = new HashSet<Object>();
            for (Object source : sources) {
                Object targetId = field.getIdAccessor().getValue(source);
                if (field.isCollection()) {
                    targetIds.addAll((Collection)targetId);
                    continue;
                }
                targetIds.add(targetId);
            }
            QuerySpec idQuerySpec = new QuerySpec(targetInformation);
            ResourceRepositoryAdapter targetAdapter = this.getTargetEntry(field).getResourceRepository();
            JsonApiResponse response = targetAdapter.findAll(targetIds, new QuerySpecAdapter(idQuerySpec, this.resourceRegistry));
            List targets = (List)response.getEntity();
            return this.toResult(fieldName, targetInformation, sources, targets);
        }
        MultivaluedMap bulkResult = new MultivaluedMap<I, D>(){

            @Override
            protected List<D> newList() {
                return new DefaultResourceList();
            }
        };
        for (Object source : sources) {
            Object sourceId = sourceInformation.getId(source);
            Object target = field.getAccessor().getValue(source);
            if (target == null) continue;
            if (field.isCollection()) {
                bulkResult.addAll(sourceId, (Collection)target);
                continue;
            }
            bulkResult.add(sourceId, target);
        }
        return bulkResult;
    }

    private MultivaluedMap<I, D> toResult(String fieldName, ResourceInformation targetInformation, List sources, List<D> targets) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceInformation sourceInformation = sourceEntry.getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        MultivaluedMap bulkResult = new MultivaluedMap<I, D>(){

            @Override
            protected List<D> newList() {
                return new DefaultResourceList();
            }
        };
        HashMap<Object, D> targetMap = new HashMap<Object, D>();
        for (D target : targets) {
            Object targetId = targetInformation.getId(target);
            targetMap.put(targetId, target);
        }
        for (Object source : sources) {
            Object sourceId = sourceInformation.getId(source);
            Object targetId = field.getIdAccessor().getValue(source);
            if (field.isCollection()) {
                for (Object targetElementId : (Collection)targetId) {
                    this.addResult(bulkResult, field, sourceId, targetElementId, targetMap);
                }
                continue;
            }
            this.addResult(bulkResult, field, sourceId, targetId, targetMap);
        }
        return bulkResult;
    }

    private void addResult(MultivaluedMap bulkResult, ResourceField field, Object sourceId, Object targetId, Map targetMap) {
        Object target = targetMap.get(targetId);
        if (target == null) {
            throw new ResourceNotFoundException("targetId=" + targetId + " not found for sourceId=" + sourceId + ", field=" + field.getUnderlyingName() + ", sourceType=" + field.getParentResourceInformation().getResourceType());
        }
        bulkResult.add(sourceId, target);
    }

    private ResourceInformation getTargetInformation(ResourceField field) {
        return this.resourceRegistry.getEntry(field.getOppositeResourceType()).getResourceInformation();
    }
}

