/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.bean;

import io.crnk.core.engine.information.bean.BeanInformation;
import io.crnk.core.utils.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanAttributeInformation {
    private String name;
    private Field field;
    private Method getter;
    private Method setter;
    private BeanInformation beanInformation;
    private Map<Class, Optional<?>> annotations = new HashMap();

    protected BeanAttributeInformation(BeanInformation beanInformation) {
        this.beanInformation = beanInformation;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    protected void setSetter(Method setter) {
        this.setter = setter;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void setGetter(Method getter) {
        this.getter = getter;
    }

    protected void setField(Field field) {
        this.field = field;
    }

    public Class<?> getImplementationClass() {
        if (this.field != null) {
            return this.field.getType();
        }
        return this.getter.getReturnType();
    }

    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        BeanAttributeInformation superAttrDesc;
        BeanInformation superTypeDescriptor;
        if (this.annotations.containsKey(annotationClass)) {
            return this.annotations.get(annotationClass);
        }
        Optional<Object> annotation = Optional.empty();
        if (this.field != null) {
            annotation = Optional.ofNullable(this.field.getAnnotation(annotationClass));
        }
        if (this.getter != null && !annotation.isPresent()) {
            annotation = Optional.ofNullable(this.getter.getAnnotation(annotationClass));
        }
        if (!annotation.isPresent()) {
            for (BeanInformation interfaceBeanDesc : this.beanInformation.getImplementedInterfaces()) {
                BeanAttributeInformation interfaceAttrDesc;
                if (interfaceBeanDesc != null && (interfaceAttrDesc = interfaceBeanDesc.getAttribute(this.name)) != null && (annotation = interfaceAttrDesc.getAnnotation(annotationClass)).isPresent()) break;
            }
        }
        if (!annotation.isPresent() && (superTypeDescriptor = this.beanInformation.getSuperType()) != null && (superAttrDesc = superTypeDescriptor.getAttribute(this.name)) != null) {
            annotation = superAttrDesc.getAnnotation(annotationClass);
        }
        this.annotations.put(annotationClass, annotation);
        return annotation;
    }

    public boolean isReadable() {
        return this.getter != null || this.field != null;
    }

    public Object getValue(Object bean) {
        try {
            if (this.getter != null) {
                return this.getter.invoke(bean, new Object[0]);
            }
            return this.field.get(bean);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setValue(Object bean, Object value) {
        try {
            if (this.setter != null) {
                this.setter.invoke(bean, value);
            } else {
                this.field.set(bean, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

