/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.filter.RepositoryFilterContext;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.RepositoryRequestSpecImpl;
import io.crnk.core.engine.internal.repository.ResponseRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.AnnotatedResourceRepositoryAdapter;
import io.crnk.legacy.repository.ResourceRepository;
import java.io.Serializable;

public class ResourceRepositoryAdapter<T, I extends Serializable>
extends ResponseRepositoryAdapter {
    private final Object resourceRepository;
    private final boolean isAnnotated;
    private boolean return404OnNull;

    public ResourceRepositoryAdapter(ResourceInformation resourceInformation, ModuleRegistry moduleRegistry, Object resourceRepository) {
        super(resourceInformation, moduleRegistry);
        this.resourceRepository = resourceRepository;
        this.isAnnotated = resourceRepository instanceof AnnotatedResourceRepositoryAdapter;
        this.return404OnNull = Boolean.parseBoolean(moduleRegistry.getPropertiesProvider().getProperty("crnk.config.resource.response.return_404"));
    }

    public JsonApiResponse findOne(I id, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                Serializable id = request.getId();
                Object resource = ResourceRepositoryAdapter.this.isAnnotated ? ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).findOne(id, queryAdapter) : (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2 ? ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).findOne(id, request.getQuerySpec(ResourceRepositoryAdapter.this.resourceInformation)) : ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).findOne(id, request.getQueryParams()));
                if (resource == null && ResourceRepositoryAdapter.this.return404OnNull) {
                    throw new ResourceNotFoundException(ResourceRepositoryAdapter.this.resourceInformation.getResourceType());
                }
                return ResourceRepositoryAdapter.this.getResponse(ResourceRepositoryAdapter.this.resourceRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindId(this.moduleRegistry, this.resourceInformation, queryAdapter, id);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse findAll(QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Iterable resources;
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (ResourceRepositoryAdapter.this.isAnnotated) {
                    resources = ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).findAll(queryAdapter);
                } else if (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2) {
                    QuerySpec querySpec = request.getQuerySpec(ResourceRepositoryAdapter.this.resourceInformation);
                    resources = ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).findAll(querySpec);
                } else {
                    resources = ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).findAll(request.getQueryParams());
                }
                return ResourceRepositoryAdapter.this.getResponse(ResourceRepositoryAdapter.this.resourceRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindAll(this.moduleRegistry, this.resourceInformation, queryAdapter);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse findAll(Iterable ids, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                Iterable ids = request.getIds();
                Iterable resources = ResourceRepositoryAdapter.this.isAnnotated ? ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).findAll(ids, queryAdapter) : (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2 ? ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).findAll(ids, request.getQuerySpec(ResourceRepositoryAdapter.this.resourceInformation)) : ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).findAll(ids, request.getQueryParams()));
                return ResourceRepositoryAdapter.this.getResponse(ResourceRepositoryAdapter.this.resourceRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindIds(this.moduleRegistry, this.resourceInformation, queryAdapter, ids);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public <S extends T> JsonApiResponse update(S entity, QueryAdapter queryAdapter) {
        return this.save(entity, queryAdapter, HttpMethod.PATCH);
    }

    public <S extends T> JsonApiResponse create(S entity, QueryAdapter queryAdapter) {
        return this.save(entity, queryAdapter, HttpMethod.POST);
    }

    private <S extends T> JsonApiResponse save(S entity, QueryAdapter queryAdapter, final HttpMethod method) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object entity = request.getEntity();
                Object resource = ResourceRepositoryAdapter.this.isAnnotated ? ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).save(entity) : (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2 ? (method == HttpMethod.POST ? ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).create(entity) : ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).save(entity)) : ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).save(entity));
                return ResourceRepositoryAdapter.this.getResponse(ResourceRepositoryAdapter.this.resourceRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forSave(this.moduleRegistry, method, this.resourceInformation, queryAdapter, entity);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse delete(I id, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                Serializable id = request.getId();
                if (ResourceRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedResourceRepositoryAdapter)ResourceRepositoryAdapter.this.resourceRepository).delete(id, queryAdapter);
                } else if (ResourceRepositoryAdapter.this.resourceRepository instanceof ResourceRepositoryV2) {
                    ((ResourceRepositoryV2)ResourceRepositoryAdapter.this.resourceRepository).delete(id);
                } else {
                    ((ResourceRepository)ResourceRepositoryAdapter.this.resourceRepository).delete(id);
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forDelete(this.moduleRegistry, this.resourceInformation, queryAdapter, id);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public Object getResourceRepository() {
        return this.resourceRepository;
    }

    public Class<?> getResourceClass() {
        return this.resourceInformation.getResourceClass();
    }
}

