/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.filter.RepositoryFilterContext;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.RepositoryRequestSpecImpl;
import io.crnk.core.engine.internal.repository.ResponseRepositoryAdapter;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.BulkRelationshipRepositoryV2;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.AnnotatedRelationshipRepositoryAdapter;
import io.crnk.legacy.repository.RelationshipRepository;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationshipRepositoryAdapter<T, I extends Serializable, D, J extends Serializable>
extends ResponseRepositoryAdapter {
    private final Object relationshipRepository;
    private final boolean isAnnotated;

    public RelationshipRepositoryAdapter(ResourceInformation resourceInformation, ModuleRegistry moduleRegistry, Object relationshipRepository) {
        super(resourceInformation, moduleRegistry);
        this.relationshipRepository = relationshipRepository;
        this.isAnnotated = relationshipRepository instanceof AnnotatedRelationshipRepositoryAdapter;
    }

    public JsonApiResponse setRelation(T source, J targetId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Serializable targetId = request.getId();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.PATCH, source, queryAdapter, Arrays.asList(targetId), field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse setRelations(T source, Iterable<J> targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.PATCH, source, queryAdapter, targetIds, field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse addRelations(T source, Iterable<J> targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.POST, source, queryAdapter, targetIds, field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse removeRelations(T source, Iterable<J> targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.DELETE, source, queryAdapter, targetIds, field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse findOneTarget(I sourceId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Object resource;
                RepositoryRequestSpec request = context.getRequest();
                Serializable sourceId = request.getId();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    resource = ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).findOneTarget(sourceId, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    RelationshipRepositoryV2 querySpecRepository = (RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapter.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    resource = querySpecRepository.findOneTarget(sourceId, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                } else {
                    resource = ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).findOneTarget(sourceId, field.getUnderlyingName(), request.getQueryParams());
                }
                return RelationshipRepositoryAdapter.this.getResponse(RelationshipRepositoryAdapter.this.relationshipRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, Arrays.asList(sourceId), field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public JsonApiResponse findManyTargets(I sourceId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Iterable resources;
                RepositoryRequestSpec request = context.getRequest();
                Serializable sourceId = request.getId();
                ResourceField field = request.getRelationshipField();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (RelationshipRepositoryAdapter.this.isAnnotated) {
                    resources = ((AnnotatedRelationshipRepositoryAdapter)RelationshipRepositoryAdapter.this.relationshipRepository).findManyTargets(sourceId, field.getUnderlyingName(), queryAdapter);
                } else if (RelationshipRepositoryAdapter.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    RelationshipRepositoryV2 querySpecRepository = (RelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapter.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    resources = querySpecRepository.findManyTargets(sourceId, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                } else {
                    resources = ((RelationshipRepository)RelationshipRepositoryAdapter.this.relationshipRepository).findManyTargets(sourceId, field.getUnderlyingName(), request.getQueryParams());
                }
                return RelationshipRepositoryAdapter.this.getResponse(RelationshipRepositoryAdapter.this.relationshipRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, Arrays.asList(sourceId), field);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    public Map<I, JsonApiResponse> findBulkManyTargets(List<I> sourceIds, ResourceField field, QueryAdapter queryAdapter) {
        if (this.relationshipRepository instanceof BulkRelationshipRepositoryV2) {
            ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl<I>(){

                @Override
                protected Map<I, JsonApiResponse> invoke(RepositoryFilterContext context) {
                    RepositoryRequestSpec request = context.getRequest();
                    Iterable sourceIds = request.getIds();
                    ResourceField field = request.getRelationshipField();
                    QueryAdapter queryAdapter = request.getQueryAdapter();
                    BulkRelationshipRepositoryV2 bulkRepository = (BulkRelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapter.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    QuerySpec querySpec = request.getQuerySpec(targetResourceInformation);
                    MultivaluedMap targetsMap = bulkRepository.findTargets(sourceIds, field.getUnderlyingName(), querySpec);
                    return RelationshipRepositoryAdapter.this.toResponses(targetsMap, true, queryAdapter, field, HttpMethod.GET);
                }
            };
            RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, sourceIds, field);
            return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
        }
        HashMap<Serializable, JsonApiResponse> responseMap = new HashMap<Serializable, JsonApiResponse>();
        for (Serializable sourceId : sourceIds) {
            JsonApiResponse response = this.findManyTargets(sourceId, field, queryAdapter);
            responseMap.put(sourceId, response);
        }
        return responseMap;
    }

    public Map<I, JsonApiResponse> findBulkOneTargets(List<I> sourceIds, ResourceField field, QueryAdapter queryAdapter) {
        if (this.relationshipRepository instanceof BulkRelationshipRepositoryV2) {
            ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl<I>(){

                @Override
                protected Map<I, JsonApiResponse> invoke(RepositoryFilterContext context) {
                    RepositoryRequestSpec request = context.getRequest();
                    Iterable sourceIds = request.getIds();
                    ResourceField field = request.getRelationshipField();
                    QueryAdapter queryAdapter = request.getQueryAdapter();
                    BulkRelationshipRepositoryV2 bulkRepository = (BulkRelationshipRepositoryV2)RelationshipRepositoryAdapter.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapter.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    MultivaluedMap targetsMap = bulkRepository.findTargets(sourceIds, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                    return RelationshipRepositoryAdapter.this.toResponses(targetsMap, false, queryAdapter, field, HttpMethod.GET);
                }
            };
            RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, sourceIds, field);
            return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
        }
        HashMap<Serializable, JsonApiResponse> responseMap = new HashMap<Serializable, JsonApiResponse>();
        for (Serializable sourceId : sourceIds) {
            JsonApiResponse response = this.findOneTarget(sourceId, field, queryAdapter);
            responseMap.put(sourceId, response);
        }
        return responseMap;
    }

    private Map<I, JsonApiResponse> toResponses(MultivaluedMap<I, D> targetsMap, boolean isMany, QueryAdapter queryAdapter, ResourceField field, HttpMethod method) {
        HashMap<Serializable, JsonApiResponse> responseMap = new HashMap<Serializable, JsonApiResponse>();
        for (Serializable sourceId : targetsMap.keySet()) {
            List<D> targets = isMany ? targetsMap.getList(sourceId) : targetsMap.getUnique(sourceId, true);
            RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, method, null, queryAdapter, Collections.singleton(sourceId), field);
            JsonApiResponse response = this.getResponse(this.relationshipRepository, targets, requestSpec);
            responseMap.put(sourceId, response);
        }
        return responseMap;
    }

    public Object getRelationshipRepository() {
        return this.relationshipRepository;
    }
}

