/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.registry;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.exception.RelationshipRepositoryNotFoundException;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.legacy.internal.DirectResponseRelationshipEntry;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import io.crnk.legacy.registry.AnnotatedRelationshipEntryBuilder;
import io.crnk.legacy.registry.AnnotatedResourceEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RegistryEntry {
    private final ResourceEntry resourceEntry;
    private final Map<ResourceField, ResponseRelationshipEntry> relationshipEntries;
    private RegistryEntry parentRegistryEntry = null;
    private ModuleRegistry moduleRegistry;

    public RegistryEntry(ResourceEntry resourceEntry) {
        this(resourceEntry, new HashMap<ResourceField, ResponseRelationshipEntry>());
    }

    public RegistryEntry(ResourceEntry resourceEntry, Map<ResourceField, ResponseRelationshipEntry> relationshipEntries) {
        this.resourceEntry = resourceEntry;
        this.relationshipEntries = relationshipEntries;
    }

    public void initialize(ModuleRegistry moduleRegistry) {
        PreconditionUtil.assertNotNull("no moduleRegistry", moduleRegistry);
        this.moduleRegistry = moduleRegistry;
    }

    public ResourceRepositoryAdapter getResourceRepository(RepositoryMethodParameterProvider parameterProvider) {
        Object repoInstance = null;
        if (this.resourceEntry instanceof DirectResponseResourceEntry) {
            repoInstance = ((DirectResponseResourceEntry)this.resourceEntry).getResourceRepository();
        } else if (this.resourceEntry instanceof AnnotatedResourceEntry) {
            repoInstance = ((AnnotatedResourceEntry)this.resourceEntry).build(parameterProvider);
        }
        if (repoInstance instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)repoInstance).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        ResourceInformation resourceInformation = this.getResourceInformation();
        return new ResourceRepositoryAdapter(resourceInformation, this.moduleRegistry, repoInstance);
    }

    public RelationshipRepositoryAdapter getRelationshipRepository(String fieldName, RepositoryMethodParameterProvider parameterProvider) {
        ResourceField field = this.getResourceInformation().findFieldByUnderlyingName(fieldName);
        if (field == null) {
            throw new ResourceFieldNotFoundException("field=" + fieldName);
        }
        return this.getRelationshipRepository(field, parameterProvider);
    }

    public RelationshipRepositoryAdapter getRelationshipRepository(ResourceField field, RepositoryMethodParameterProvider parameterProvider) {
        ResponseRelationshipEntry relationshipEntry = this.relationshipEntries.get(field);
        if (relationshipEntry == null) {
            throw new RelationshipRepositoryNotFoundException(this.getResourceInformation().getResourceType(), field.getUnderlyingName());
        }
        Object repoInstance = relationshipEntry instanceof AnnotatedRelationshipEntryBuilder ? ((AnnotatedRelationshipEntryBuilder)relationshipEntry).build(parameterProvider) : ((DirectResponseRelationshipEntry)relationshipEntry).getRepositoryInstanceBuilder();
        if (repoInstance instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)repoInstance).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        return new RelationshipRepositoryAdapter(this.getResourceInformation(), this.moduleRegistry, repoInstance);
    }

    public ResourceInformation getResourceInformation() {
        return this.resourceEntry.getRepositoryInformation().getResourceInformation().get();
    }

    public ResourceRepositoryInformation getRepositoryInformation() {
        return this.resourceEntry.getRepositoryInformation();
    }

    public RegistryEntry getParentRegistryEntry() {
        ResourceInformation resourceInformation = this.getResourceInformation();
        String superResourceType = resourceInformation.getSuperResourceType();
        if (superResourceType != null) {
            ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
            return resourceRegistry.getEntry(superResourceType);
        }
        return this.parentRegistryEntry;
    }

    @Deprecated
    public void setParentRegistryEntry(RegistryEntry parentRegistryEntry) {
        this.parentRegistryEntry = parentRegistryEntry;
    }

    public boolean isParent(RegistryEntry registryEntry) {
        for (RegistryEntry entry = this.getParentRegistryEntry(); entry != null; entry = entry.getParentRegistryEntry()) {
            if (!entry.equals(registryEntry)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public ResourceRepositoryAdapter getResourceRepository() {
        return this.getResourceRepository(null);
    }

    public <T, I extends Serializable> ResourceRepositoryV2<T, I> getResourceRepositoryFacade() {
        return new ResourceRepositoryFacade();
    }

    public Map<ResourceField, ResponseRelationshipEntry> getRelationshipEntries() {
        return this.relationshipEntries;
    }

    private ResourceList toResources(JsonApiResponse response) {
        Collection elements = (Collection)this.toResource(response);
        DefaultResourceList result = new DefaultResourceList();
        result.addAll(elements);
        result.setMeta(response.getMetaInformation());
        result.setLinks(response.getLinksInformation());
        return result;
    }

    private Object toResource(JsonApiResponse response) {
        if (response.getErrors() != null && response.getErrors().iterator().hasNext()) {
            ArrayList<ErrorData> errorList = new ArrayList<ErrorData>();
            response.getErrors().forEach(it -> errorList.add((ErrorData)it));
            Optional errorCode = errorList.stream().filter(it -> it.getStatus() != null).map(it -> Integer.parseInt(it.getStatus())).collect(Collectors.maxBy(Integer::compare));
            ErrorResponse errorResponse = new ErrorResponse(errorList, (Integer)errorCode.get());
            ExceptionMapperRegistry exceptionMapperRegistry = this.moduleRegistry.getExceptionMapperRegistry();
            ExceptionMapper exceptionMapper = exceptionMapperRegistry.findMapperFor(errorResponse).get();
            return exceptionMapper.fromErrorResponse(errorResponse);
        }
        return response.getEntity();
    }

    class ResourceRepositoryFacade
    implements ResourceRepositoryV2<Object, Serializable> {
        ResourceRepositoryFacade() {
        }

        @Override
        public Class getResourceClass() {
            return RegistryEntry.this.getResourceInformation().getResourceClass();
        }

        @Override
        public Object findOne(Serializable id, QuerySpec querySpec) {
            ResourceRepositoryAdapter adapter = RegistryEntry.this.getResourceRepository();
            return RegistryEntry.this.toResource(adapter.findOne(id, this.toAdapter(querySpec)));
        }

        @Override
        public ResourceList findAll(QuerySpec querySpec) {
            ResourceRepositoryAdapter adapter = RegistryEntry.this.getResourceRepository();
            return RegistryEntry.this.toResources(adapter.findAll(this.toAdapter(querySpec)));
        }

        @Override
        public ResourceList findAll(Iterable ids, QuerySpec querySpec) {
            ResourceRepositoryAdapter adapter = RegistryEntry.this.getResourceRepository();
            return RegistryEntry.this.toResources(adapter.findAll(ids, this.toAdapter(querySpec)));
        }

        @Override
        public Object save(Object resource) {
            ResourceRepositoryAdapter adapter = RegistryEntry.this.getResourceRepository();
            return RegistryEntry.this.toResource(adapter.update(resource, this.createEmptyAdapter()));
        }

        @Override
        public Object create(Object resource) {
            ResourceRepositoryAdapter adapter = RegistryEntry.this.getResourceRepository();
            return RegistryEntry.this.toResource(adapter.create(resource, this.createEmptyAdapter()));
        }

        @Override
        public void delete(Serializable id) {
            ResourceRepositoryAdapter adapter = RegistryEntry.this.getResourceRepository();
            RegistryEntry.this.toResource(adapter.delete(id, this.createEmptyAdapter()));
        }

        private QueryAdapter createEmptyAdapter() {
            return this.toAdapter(new QuerySpec(this.getResourceClass()));
        }

        private QueryAdapter toAdapter(QuerySpec querySpec) {
            return new QuerySpecAdapter(querySpec, RegistryEntry.this.moduleRegistry.getResourceRegistry());
        }
    }
}

