/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module.discovery;

import com.google.common.base.Predicate;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.repository.Repository;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.legacy.locator.JsonServiceLocator;
import io.crnk.legacy.locator.SampleJsonServiceLocator;
import io.crnk.legacy.repository.ResourceRepository;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ReflectionsServiceDiscovery
implements ServiceDiscovery {
    private Reflections reflections;
    private JsonServiceLocator locator;

    public ReflectionsServiceDiscovery(String resourceSearchPackages) {
        this(resourceSearchPackages, new SampleJsonServiceLocator());
    }

    public ReflectionsServiceDiscovery(String resourceSearchPackages, JsonServiceLocator locator) {
        this.locator = locator;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        PreconditionUtil.assertNotNull("no resourceSearchPackage configured", resourceSearchPackages);
        FilterBuilder filter = new FilterBuilder();
        for (String resourceSearchPackage : resourceSearchPackages.split(",")) {
            builder = builder.addUrls(ClasspathHelper.forPackage((String)resourceSearchPackage, (ClassLoader[])new ClassLoader[0]));
            filter.includePackage(new String[]{resourceSearchPackage});
        }
        filter.includePackage(new String[]{Repository.class.getPackage().getName()});
        filter.includePackage(new String[]{ResourceRepository.class.getPackage().getName()});
        builder = builder.filterInputsBy((Predicate)filter);
        builder = builder.addUrls(new URL[]{ClasspathHelper.forClass(Repository.class, (ClassLoader[])new ClassLoader[0])});
        builder = builder.addUrls(new URL[]{ClasspathHelper.forClass(ResourceRepository.class, (ClassLoader[])new ClassLoader[0])});
        builder = builder.addUrls(new URL[]{ClasspathHelper.forClass(ResourceRepositoryV2.class, (ClassLoader[])new ClassLoader[0])});
        builder = builder.setScanners(new Scanner[]{new SubTypesScanner(false), new TypeAnnotationsScanner()});
        this.reflections = new Reflections((Configuration)builder);
    }

    public JsonServiceLocator getLocator() {
        return this.locator;
    }

    private static boolean isValid(Class<?> type) {
        return !Modifier.isPrivate(type.getModifiers()) && !type.isInterface() && !Modifier.isAbstract(type.getModifiers()) && ReflectionsServiceDiscovery.hasDefaultConstructor(type);
    }

    private static boolean hasDefaultConstructor(Class<?> type) {
        for (Constructor<?> constructor : type.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> List<T> getInstancesByType(Class<T> clazz) {
        Set types = this.reflections.getSubTypesOf(clazz);
        return this.getInstances(types);
    }

    @Override
    public <A extends Annotation> List<Object> getInstancesByAnnotation(Class<A> annotation) {
        Set types = this.reflections.getTypesAnnotatedWith(annotation);
        return this.getInstances(types);
    }

    private <T> List<T> getInstances(Set<Class<? extends T>> types) {
        ArrayList<T> instances = new ArrayList<T>();
        for (Class<T> clazz : types) {
            T instance;
            if (!ReflectionsServiceDiscovery.isValid(clazz) || (instance = this.locator.getInstance(clazz)) == null) continue;
            instances.add(instance);
        }
        return instances;
    }
}

