/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.QuerySpecSerializer;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.resource.RestrictedQueryParamsMembers;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultQuerySpecSerializer
implements QuerySpecSerializer {
    private ResourceRegistry resourceRegistry;

    public DefaultQuerySpecSerializer(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    private static void put(Map<String, Set<String>> map, String key, String value) {
        map.put(key, new HashSet<String>(Arrays.asList(value)));
    }

    private static String toKey(List<String> attributePath) {
        return "[" + StringUtils.join(".", attributePath) + "]";
    }

    private static String addResourceType(RestrictedQueryParamsMembers type, String key, String resourceType) {
        return type.toString() + "[" + resourceType + "]" + (key != null ? key : "");
    }

    private static String serializeValue(Object value) {
        return value.toString();
    }

    @Override
    public Map<String, Set<String>> serialize(QuerySpec querySpec) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        this.serialize(querySpec, map, querySpec);
        return map;
    }

    private void serialize(QuerySpec querySpec, Map<String, Set<String>> map, QuerySpec parentQuerySpec) {
        RegistryEntry entry;
        String resourceType = querySpec.getResourceType();
        if (resourceType == null) {
            entry = this.resourceRegistry.getEntry(querySpec.getResourceClass());
            if (entry == null) {
                throw new RepositoryNotFoundException(querySpec.getResourceClass());
            }
            resourceType = entry.getResourceInformation().getResourceType();
        }
        this.serializeFilters(querySpec, resourceType, map);
        this.serializeSorting(querySpec, resourceType, map);
        this.serializeIncludedFields(querySpec, resourceType, map);
        this.serializeIncludedRelations(querySpec, resourceType, map);
        entry = this.resourceRegistry.getEntry(parentQuerySpec.getResourceClass());
        if (entry != null && entry.getResourceInformation() != null && entry.getResourceInformation().getPagingBehavior() != null) {
            map.putAll(entry.getResourceInformation().getPagingBehavior().serialize(querySpec.getPagingSpec(), resourceType));
        }
        for (QuerySpec relatedSpec : querySpec.getRelatedSpecs().values()) {
            this.serialize(relatedSpec, map, querySpec);
        }
    }

    void serializeFilters(QuerySpec querySpec, String resourceType, Map<String, Set<String>> map) {
        for (FilterSpec filterSpec : querySpec.getFilters()) {
            if (filterSpec.hasExpressions()) {
                throw new UnsupportedOperationException("filter expressions like and and or not yet supported");
            }
            String attrKey = DefaultQuerySpecSerializer.toKey(filterSpec.getAttributePath()) + "[" + filterSpec.getOperator().getName() + "]";
            String key = DefaultQuerySpecSerializer.addResourceType(RestrictedQueryParamsMembers.filter, attrKey, resourceType);
            if (filterSpec.getValue() instanceof Collection) {
                Collection col = (Collection)filterSpec.getValue();
                HashSet<String> values = new HashSet<String>();
                for (Object elem : col) {
                    values.add(DefaultQuerySpecSerializer.serializeValue(elem));
                }
                map.put(key, values);
                continue;
            }
            String value = DefaultQuerySpecSerializer.serializeValue(filterSpec.getValue());
            DefaultQuerySpecSerializer.put(map, key, value);
        }
    }

    public void serializeSorting(QuerySpec querySpec, String resourceType, Map<String, Set<String>> map) {
        if (!querySpec.getSort().isEmpty()) {
            String key = DefaultQuerySpecSerializer.addResourceType(RestrictedQueryParamsMembers.sort, null, resourceType);
            StringBuilder builder = new StringBuilder();
            for (SortSpec filterSpec : querySpec.getSort()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                if (filterSpec.getDirection() == Direction.DESC) {
                    builder.append("-");
                }
                builder.append(StringUtils.join(".", filterSpec.getAttributePath()));
            }
            DefaultQuerySpecSerializer.put(map, key, builder.toString());
        }
    }

    void serializeIncludedFields(QuerySpec querySpec, String resourceType, Map<String, Set<String>> map) {
        if (!querySpec.getIncludedFields().isEmpty()) {
            String key = DefaultQuerySpecSerializer.addResourceType(RestrictedQueryParamsMembers.fields, null, resourceType);
            StringBuilder builder = new StringBuilder();
            for (IncludeFieldSpec includedField : querySpec.getIncludedFields()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(StringUtils.join(".", includedField.getAttributePath()));
            }
            DefaultQuerySpecSerializer.put(map, key, builder.toString());
        }
    }

    void serializeIncludedRelations(QuerySpec querySpec, String resourceType, Map<String, Set<String>> map) {
        if (!querySpec.getIncludedRelations().isEmpty()) {
            String key = DefaultQuerySpecSerializer.addResourceType(RestrictedQueryParamsMembers.include, null, resourceType);
            StringBuilder builder = new StringBuilder();
            for (IncludeRelationSpec includedField : querySpec.getIncludedRelations()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(StringUtils.join(".", includedField.getAttributePath()));
            }
            DefaultQuerySpecSerializer.put(map, key, builder.toString());
        }
    }
}

