/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository;

import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.RelationshipMatcher;
import io.crnk.core.repository.Repository;
import io.crnk.core.repository.UntypedRelationshipRepository;
import io.crnk.core.resource.list.ResourceList;
import java.io.Serializable;

public interface RelationshipRepositoryV2<T, I extends Serializable, D, J extends Serializable>
extends Repository {
    public Class<T> getSourceResourceClass();

    public Class<D> getTargetResourceClass();

    default public RelationshipMatcher getMatcher() {
        if (this instanceof UntypedRelationshipRepository) {
            UntypedRelationshipRepository untyped = (UntypedRelationshipRepository)this;
            RelationshipMatcher matcher = new RelationshipMatcher();
            matcher.rule().source(untyped.getSourceResourceType()).target(untyped.getTargetResourceType()).add();
            return matcher;
        }
        Class<T> sourceResourceClass = this.getSourceResourceClass();
        Class<D> targetResourceClass = this.getTargetResourceClass();
        if (sourceResourceClass != null && targetResourceClass != null) {
            RelationshipMatcher matcher = new RelationshipMatcher();
            matcher.rule().source(this.getSourceResourceClass()).target(targetResourceClass).add();
            return matcher;
        }
        throw new IllegalStateException("implement getMatcher()");
    }

    public void setRelation(T var1, J var2, String var3);

    public void setRelations(T var1, Iterable<J> var2, String var3);

    public void addRelations(T var1, Iterable<J> var2, String var3);

    public void removeRelations(T var1, Iterable<J> var2, String var3);

    public D findOneTarget(I var1, String var2, QuerySpec var3);

    public ResourceList<D> findManyTargets(I var1, String var2, QuerySpec var3);
}

