/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.document;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import java.util.Objects;

public class ResourceIdentifier
implements Comparable<ResourceIdentifier> {
    protected String id;
    protected String type;

    public ResourceIdentifier() {
    }

    public ResourceIdentifier(String id, String type) {
        PreconditionUtil.assertNotNull("id cannot be null", id);
        PreconditionUtil.assertNotNull("type cannot be null", type);
        PreconditionUtil.assertFalse("cannot pass ResourceIdentifier as id", id.startsWith("ResourceIdentifier{id="));
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type);
    }

    @Override
    public int compareTo(ResourceIdentifier o) {
        int d = this.type.compareTo(o.type);
        if (d != 0) {
            return d;
        }
        return this.id.compareTo(o.id);
    }

    public String toString() {
        return "ResourceIdentifier{id='" + this.id + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

