/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.document.mapper.IncludeLookupSetter;
import io.crnk.core.engine.internal.document.mapper.ResourceMapper;
import io.crnk.core.engine.internal.document.mapper.ResourceMappingConfig;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DocumentMapper {
    private final ResourceFilterDirectory resourceFilterDirectory;
    protected PropertiesProvider propertiesProvider;
    private DocumentMapperUtil util;
    private ResourceMapper resourceMapper;
    private IncludeLookupSetter includeLookupSetter;
    private boolean client;

    public DocumentMapper(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider, ResourceFilterDirectory resourceFilterDirectory) {
        this(resourceRegistry, objectMapper, propertiesProvider, resourceFilterDirectory, false);
    }

    public DocumentMapper(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider, ResourceFilterDirectory resourceFilterDirectory, boolean client) {
        this.propertiesProvider = propertiesProvider;
        this.client = client;
        this.resourceFilterDirectory = resourceFilterDirectory;
        PreconditionUtil.assertTrue("filterBehavior necessary on server-side", client || resourceFilterDirectory != null);
        this.util = this.newDocumentMapperUtil(resourceRegistry, objectMapper, propertiesProvider);
        this.resourceMapper = this.newResourceMapper(this.util, client, objectMapper);
        this.includeLookupSetter = this.newIncludeLookupSetter(resourceRegistry, this.resourceMapper, propertiesProvider);
    }

    public ResourceFilterDirectory getFilterBehaviorManager() {
        return this.resourceFilterDirectory;
    }

    protected IncludeLookupSetter newIncludeLookupSetter(ResourceRegistry resourceRegistry, ResourceMapper resourceMapper, PropertiesProvider propertiesProvider) {
        return new IncludeLookupSetter(resourceRegistry, resourceMapper, propertiesProvider);
    }

    protected DocumentMapperUtil newDocumentMapperUtil(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider) {
        return new DocumentMapperUtil(resourceRegistry, objectMapper, propertiesProvider);
    }

    protected ResourceMapper newResourceMapper(DocumentMapperUtil util, boolean client, ObjectMapper objectMapper) {
        return new ResourceMapper(util, client, objectMapper, this.resourceFilterDirectory);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter) {
        return this.toDocument(response, queryAdapter, (RepositoryMethodParameterProvider)null);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Set<String> mappingConfig = Collections.emptySet();
        return this.toDocument(response, queryAdapter, parameterProvider, mappingConfig);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> fieldsWidthEnforcedIdSerialization) {
        DocumentMappingConfig mappingConfig = new DocumentMappingConfig();
        mappingConfig.setParameterProvider(parameterProvider);
        mappingConfig.setFieldsWithEnforcedIdSerialization(fieldsWidthEnforcedIdSerialization);
        return this.toDocument(response, queryAdapter, mappingConfig);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter, DocumentMappingConfig mappingConfig) {
        if (response == null) {
            return null;
        }
        ResourceMappingConfig resourceMapping = mappingConfig.getResourceMapping();
        Document doc = new Document();
        this.addErrors(doc, response.getErrors());
        this.util.setMeta(doc, response.getMetaInformation());
        if (mappingConfig.getResourceMapping().getSerializeLinks()) {
            this.util.setLinks(doc, response.getLinksInformation(), queryAdapter);
        }
        this.addData(doc, response.getEntity(), queryAdapter, resourceMapping);
        this.addRelationDataAndInclusions(doc, response.getEntity(), queryAdapter, mappingConfig);
        if (queryAdapter != null && queryAdapter.getCompactMode()) {
            this.compact(doc);
        }
        return doc;
    }

    private void compact(Document doc) {
        if (doc.getIncluded() != null) {
            this.compact(doc.getIncluded());
        }
        if (doc.getData().isPresent()) {
            if (doc.isMultiple()) {
                this.compact(doc.getCollectionData().get());
            }
        } else {
            this.compact(doc.getSingleData().get());
        }
    }

    private void compact(List<Resource> resources) {
        if (resources != null) {
            for (Resource resource : resources) {
                this.compact(resource);
            }
        }
    }

    private void compact(Resource resource) {
        Iterator<Relationship> iterator = resource.getRelationships().values().iterator();
        while (iterator.hasNext()) {
            Relationship rel = iterator.next();
            if (rel.getData().isPresent()) continue;
            iterator.remove();
        }
    }

    private void addRelationDataAndInclusions(Document doc, Object entity, QueryAdapter queryAdapter, DocumentMappingConfig mappingConfig) {
        if (doc.getData().isPresent() && !this.client) {
            RepositoryMethodParameterProvider parameterProvider = mappingConfig.getParameterProvider();
            Set<String> fieldsWithEnforceIdSerialization = mappingConfig.getFieldsWithEnforcedIdSerialization();
            this.includeLookupSetter.setIncludedElements(doc, entity, queryAdapter, parameterProvider, fieldsWithEnforceIdSerialization);
        }
    }

    private void addData(Document doc, Object entity, QueryAdapter queryAdapter, ResourceMappingConfig resourceMappingConfig) {
        if (entity != null) {
            if (entity instanceof Iterable) {
                ArrayList<Resource> dataList = new ArrayList<Resource>();
                for (Object obj : (Iterable)entity) {
                    dataList.add(this.resourceMapper.toData(obj, queryAdapter, resourceMappingConfig));
                }
                doc.setData(Nullable.of(dataList));
            } else {
                doc.setData(Nullable.of(this.resourceMapper.toData(entity, queryAdapter, resourceMappingConfig)));
            }
        }
    }

    private void addErrors(Document doc, Iterable<ErrorData> errors) {
        if (errors != null) {
            ArrayList<ErrorData> errorList = new ArrayList<ErrorData>();
            for (ErrorData error : errors) {
                errorList.add(error);
            }
            doc.setErrors(errorList);
        }
    }
}

