/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.document.mapper.IncludeBehavior;
import io.crnk.core.engine.internal.document.mapper.IncludeLookupUtil;
import io.crnk.core.engine.internal.document.mapper.ResourceMapper;
import io.crnk.core.engine.internal.document.mapper.ResourceMappingConfig;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.InternalServerErrorException;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.annotations.JsonApiLookupIncludeAutomatically;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.internal.QueryParamsAdapter;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeLookupSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeLookupSetter.class);
    private final ResourceRegistry resourceRegistry;
    private ResourceMapper resourceMapper;
    private IncludeLookupUtil util;
    private boolean allowPagination = false;

    public IncludeLookupSetter(ResourceRegistry resourceRegistry, ResourceMapper resourceMapper, PropertiesProvider propertiesProvider) {
        this.resourceMapper = resourceMapper;
        this.resourceRegistry = resourceRegistry;
        IncludeBehavior includeBehavior = IncludeLookupUtil.getIncludeBehavior(propertiesProvider);
        this.util = new IncludeLookupUtil(resourceRegistry, includeBehavior);
        this.allowPagination = propertiesProvider != null && Boolean.parseBoolean(propertiesProvider.getProperty("crnk.config.include.paging.enabled"));
    }

    @Deprecated
    public void setIncludedElements(Document document, Object entity, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> fieldsWithEnforceIdSerialization) {
        DocumentMappingConfig mappingConfig = new DocumentMappingConfig();
        mappingConfig.setParameterProvider(parameterProvider);
        mappingConfig.setFieldsWithEnforcedIdSerialization(fieldsWithEnforceIdSerialization);
        this.setIncludedElements(document, entity, queryAdapter, mappingConfig);
    }

    public void setIncludedElements(Document document, Object entity, QueryAdapter queryAdapter, DocumentMappingConfig mappingConfig) {
        QueryAdapter inclusionQueryAdapter = queryAdapter;
        if (!this.allowPagination && !(queryAdapter instanceof QueryParamsAdapter) && queryAdapter != null) {
            inclusionQueryAdapter = queryAdapter.duplicate();
            if (queryAdapter.getResourceInformation().getPagingBehavior() != null) {
                inclusionQueryAdapter.setPagingSpec((PagingSpec)queryAdapter.getResourceInformation().getPagingBehavior().createEmptyPagingSpec());
            }
        }
        List entityList = DocumentMapperUtil.toList(entity);
        List<Resource> dataList = DocumentMapperUtil.toList(document.getData().get());
        HashMap<ResourceIdentifier, Resource> dataMap = new HashMap<ResourceIdentifier, Resource>();
        HashMap<ResourceIdentifier, Object> entityMap = new HashMap<ResourceIdentifier, Object>();
        for (int i = 0; i < dataList.size(); ++i) {
            Resource dataElement = (Resource)dataList.get(i);
            ResourceIdentifier id = dataElement.toIdentifier();
            entityMap.put(id, entityList.get(i));
            dataMap.put(id, dataElement);
        }
        HashMap<ResourceIdentifier, Resource> resourceMap = new HashMap<ResourceIdentifier, Resource>();
        resourceMap.putAll(dataMap);
        HashSet<ResourceIdentifier> inclusions = new HashSet<ResourceIdentifier>();
        PopulatedCache populatedCache = new PopulatedCache();
        RepositoryMethodParameterProvider parameterProvider = mappingConfig.getParameterProvider();
        Set<String> fieldsWithEnforcedIdSerialization = mappingConfig.getFieldsWithEnforcedIdSerialization();
        ResourceMappingConfig resourceMappingConfig = mappingConfig.getResourceMapping();
        ArrayList<ResourceField> stack = new ArrayList<ResourceField>();
        this.populate(dataList, inclusions, resourceMap, entityMap, stack, inclusionQueryAdapter, parameterProvider, fieldsWithEnforcedIdSerialization, populatedCache, resourceMappingConfig);
        inclusions.removeAll(dataMap.keySet());
        ArrayList<Resource> included = new ArrayList<Resource>();
        for (ResourceIdentifier inclusionId : inclusions) {
            Resource includedResource = (Resource)resourceMap.get(inclusionId);
            PreconditionUtil.assertNotNull("resource not found", includedResource);
            included.add(includedResource);
        }
        Collections.sort(included);
        LOGGER.debug("Extracted included resources {}", (Object)included.toString());
        document.setIncluded(included);
    }

    private void populate(Collection<Resource> resourceList, Set<ResourceIdentifier> inclusions, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, List<ResourceField> fieldPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> fieldsWithEnforceIdSerialization, PopulatedCache populatedCache, ResourceMappingConfig resourceMappingConfig) {
        if (resourceList.isEmpty()) {
            return;
        }
        this.checkNoRecursion(fieldPath);
        Set<ResourceField> relationshipFields = this.util.getRelationshipFields(resourceList);
        for (ResourceField resourceField : relationshipFields) {
            fieldPath.add(resourceField);
            this.populateField(resourceField, queryAdapter, fieldPath, populatedCache, resourceList, fieldsWithEnforceIdSerialization, parameterProvider, resourceMap, entityMap, inclusions, resourceMappingConfig);
            fieldPath.remove(fieldPath.size() - 1);
        }
    }

    private void populateField(ResourceField resourceField, QueryAdapter queryAdapter, List<ResourceField> fieldPath, PopulatedCache populatedCache, Collection<Resource> resourceList, Set<String> fieldsWithEnforceIdSerialization, RepositoryMethodParameterProvider parameterProvider, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, Set<ResourceIdentifier> inclusions, ResourceMappingConfig resourceMappingConfig) {
        Collection<Resource> unpopulatedResourceList;
        boolean includeRelationshipData;
        ResourceInformation resourceInformation = resourceField.getParentResourceInformation();
        boolean includeRequested = this.util.isInclusionRequested(queryAdapter, fieldPath);
        boolean includeResources = includeRequested || resourceField.getSerializeType() == SerializeType.EAGER;
        boolean includeRelationId = resourceField.getSerializeType() != SerializeType.LAZY || fieldsWithEnforceIdSerialization.contains(resourceField.getJsonName());
        boolean bl = includeRelationshipData = includeRelationId || includeResources;
        if (includeRelationshipData && !(unpopulatedResourceList = populatedCache.filterProcessed(resourceList, resourceField)).isEmpty()) {
            Set<Object> populatedResources;
            List<Resource> resourcesByType = this.util.filterByType(unpopulatedResourceList, resourceInformation);
            List<Resource> resourcesWithField = this.util.filterByLoadedRelationship(resourcesByType, resourceField);
            LookupIncludeBehavior fieldLookupIncludeBehavior = resourceField.getLookupIncludeAutomatically();
            if (!includeResources && resourceField.hasIdField()) {
                this.fetchRelationFromEntity(resourcesWithField, resourceField, queryAdapter, resourceMap, entityMap, false, false, includeResources, resourceMappingConfig);
                populatedResources = Collections.emptySet();
            } else if (fieldLookupIncludeBehavior == LookupIncludeBehavior.AUTOMATICALLY_ALWAYS) {
                this.fetchRelationFromEntity(resourcesWithField, resourceField, queryAdapter, resourceMap, entityMap, false, false, includeResources, resourceMappingConfig);
                populatedResources = this.lookupRelatedResource(resourcesWithField, resourceField, queryAdapter, parameterProvider, resourceMap, entityMap, resourceMappingConfig);
            } else if (fieldLookupIncludeBehavior == LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL) {
                Set<Resource> extractedResources = this.fetchRelationFromEntity(resourcesWithField, resourceField, queryAdapter, resourceMap, entityMap, true, true, includeResources, resourceMappingConfig);
                List<Resource> resourcesForLookup = this.util.findResourcesWithoutRelationshipToLoad(resourcesWithField, resourceField, resourceMap);
                Set<Resource> lookedupResources = this.lookupRelatedResource(resourcesForLookup, resourceField, queryAdapter, parameterProvider, resourceMap, entityMap, resourceMappingConfig);
                populatedResources = this.util.union(lookedupResources, extractedResources);
            } else {
                populatedResources = this.fetchRelationFromEntity(resourcesWithField, resourceField, queryAdapter, resourceMap, entityMap, false, true, includeResources, resourceMappingConfig);
                if (!Iterable.class.isAssignableFrom(resourceField.getType())) {
                    Nullable<Object> emptyData = Nullable.nullValue();
                    for (Resource resourceWithField : resourcesWithField) {
                        Relationship relationship = resourceWithField.getRelationships().get(resourceField.getJsonName());
                        if (relationship.getData().isPresent()) continue;
                        relationship.setData(emptyData);
                    }
                }
            }
            if (includeResources && !populatedResources.isEmpty()) {
                inclusions.addAll(this.util.toIds(populatedResources));
                Set<String> additionalEagerLoadedNestedRelations = Collections.emptySet();
                this.populate(populatedResources, inclusions, resourceMap, entityMap, fieldPath, queryAdapter, parameterProvider, additionalEagerLoadedNestedRelations, populatedCache, resourceMappingConfig);
            }
        }
    }

    private void checkNoRecursion(List<ResourceField> fieldPath) {
        int index = fieldPath.size();
        if (index >= 42) {
            throw new IllegalStateException("42 nested inclusions reached, aborting");
        }
    }

    private Set<Resource> fetchRelationFromEntity(List<Resource> sourceResources, ResourceField relationshipField, QueryAdapter queryAdapter, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, boolean allowLookup, boolean fetchRelatedEntity, boolean mustInclude, ResourceMappingConfig resourceMappingConfig) {
        HashSet<Resource> loadedResources = new HashSet<Resource>();
        for (Resource sourceResource : sourceResources) {
            ResourceIdentifier id = sourceResource.toIdentifier();
            Object sourceEntity = entityMap.get(id);
            if (sourceEntity == null || sourceEntity instanceof Resource) continue;
            Object relatedEntity = null;
            if (fetchRelatedEntity) {
                relatedEntity = relationshipField.getAccessor().getValue(sourceEntity);
                if (!allowLookup && Iterable.class.isAssignableFrom(relationshipField.getType()) && relatedEntity == null) {
                    throw new InternalServerErrorException(id + " relationship field collection '" + relationshipField.getJsonName() + "' can not be null. Either set the relationship as an empty " + Iterable.class.getCanonicalName() + " or add annotation @" + JsonApiLookupIncludeAutomatically.class.getCanonicalName());
                }
            }
            if (relatedEntity != null) {
                List<Resource> relatedResources = this.setupRelation(sourceResource, relationshipField, relatedEntity, queryAdapter, resourceMap, entityMap, resourceMappingConfig);
                loadedResources.addAll(relatedResources);
                continue;
            }
            if (!relationshipField.hasIdField()) continue;
            Object relatedEntityID = relationshipField.getIdAccessor().getValue(sourceEntity);
            this.setupRelationId(sourceResource, relationshipField, relatedEntityID);
            if (!fetchRelatedEntity || relatedEntityID == null || allowLookup || !mustInclude) continue;
            throw new IllegalStateException("inconsistent relationship '" + relationshipField.getUnderlyingName() + "' for " + id + ", id " + "set to " + relatedEntityID + ", but related object is null and lookup disabled");
        }
        return loadedResources;
    }

    private Set<Resource> lookupRelatedResource(Collection<Resource> sourceResources, ResourceField relationshipField, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, ResourceMappingConfig resourceMappingConfig) {
        if (sourceResources.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Resource> sourceResourcesWithData = new ArrayList<Resource>();
        ArrayList<Resource> sourceResourcesWithoutData = new ArrayList<Resource>();
        for (Resource sourceResource : sourceResources) {
            boolean present = sourceResource.getRelationships().get(relationshipField.getJsonName()).getData().isPresent();
            if (present) {
                sourceResourcesWithData.add(sourceResource);
                continue;
            }
            sourceResourcesWithoutData.add(sourceResource);
        }
        HashSet<Resource> relatedResources = new HashSet<Resource>();
        if (!sourceResourcesWithData.isEmpty()) {
            relatedResources.addAll(this.lookupRelatedResourcesWithId(sourceResourcesWithData, relationshipField, queryAdapter, parameterProvider, resourceMap, entityMap, resourceMappingConfig));
        }
        if (!sourceResourcesWithoutData.isEmpty()) {
            relatedResources.addAll(this.lookupRelatedResourceWithRelationship(sourceResourcesWithoutData, relationshipField, queryAdapter, parameterProvider, resourceMap, entityMap, resourceMappingConfig));
        }
        return relatedResources;
    }

    private Set<Resource> lookupRelatedResourcesWithId(Collection<Resource> sourceResources, ResourceField relationshipField, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, ResourceMappingConfig resourceMappingConfig) {
        String oppositeResourceType = relationshipField.getOppositeResourceType();
        RegistryEntry oppositeEntry = this.resourceRegistry.getEntry(oppositeResourceType);
        if (oppositeEntry == null) {
            throw new RepositoryNotFoundException("no resource with type " + oppositeResourceType + " found");
        }
        ResourceInformation oppositeResourceInformation = oppositeEntry.getResourceInformation();
        ResourceRepositoryAdapter oppositeResourceRepository = oppositeEntry.getResourceRepository(parameterProvider);
        if (oppositeResourceRepository == null) {
            throw new RepositoryNotFoundException("no relationship repository found for " + oppositeResourceInformation.getResourceType());
        }
        HashSet<Resource> related = new HashSet<Resource>();
        HashSet<Serializable> relatedIdsToLoad = new HashSet<Serializable>();
        for (Resource sourceResource : sourceResources) {
            Relationship relationship = sourceResource.getRelationships().get(relationshipField.getJsonName());
            PreconditionUtil.assertTrue("expected relationship data to be loaded for @JsonApiResourceId annotated field", relationship.getData().isPresent());
            if (relationship.getData().get() == null) continue;
            for (ResourceIdentifier id : relationship.getCollectionData().get()) {
                if (resourceMap.containsKey(id)) {
                    related.add(resourceMap.get(id));
                    continue;
                }
                relatedIdsToLoad.add(oppositeResourceInformation.parseIdString(id.getId()));
            }
        }
        if (!relatedIdsToLoad.isEmpty()) {
            JsonApiResponse response = oppositeResourceRepository.findAll(relatedIdsToLoad, queryAdapter);
            Collection responseList = (Collection)response.getEntity();
            for (Object responseEntity : responseList) {
                Resource relatedResource = this.mergeResource(responseEntity, queryAdapter, resourceMap, entityMap, resourceMappingConfig);
                related.add(relatedResource);
                Object responseEntityId = oppositeResourceInformation.getId(responseEntity);
                relatedIdsToLoad.remove(responseEntityId);
            }
            if (!relatedIdsToLoad.isEmpty()) {
                throw new ResourceNotFoundException("type=" + relationshipField.getOppositeResourceType() + ", " + "ids=" + relatedIdsToLoad);
            }
        }
        return related;
    }

    private Set<Resource> lookupRelatedResourceWithRelationship(Collection<Resource> sourceResources, ResourceField relationshipField, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, ResourceMappingConfig resourceMappingConfig) {
        ResourceInformation resourceInformation = relationshipField.getParentResourceInformation();
        RegistryEntry registyEntry = this.resourceRegistry.getEntry(resourceInformation.getResourceType());
        List<Serializable> resourceIds = this.getIds(sourceResources, resourceInformation);
        boolean isMany = Iterable.class.isAssignableFrom(relationshipField.getType());
        HashSet<Resource> loadedTargets = new HashSet<Resource>();
        RelationshipRepositoryAdapter relationshipRepository = registyEntry.getRelationshipRepository(relationshipField, parameterProvider);
        if (relationshipRepository != null) {
            Map<Serializable, JsonApiResponse> responseMap = isMany ? relationshipRepository.findBulkManyTargets(resourceIds, relationshipField, queryAdapter) : relationshipRepository.findBulkOneTargets(resourceIds, relationshipField, queryAdapter);
            for (Resource sourceResource : sourceResources) {
                Serializable sourceId = resourceInformation.parseIdString(sourceResource.getId());
                JsonApiResponse targetResponse = responseMap.get(sourceId);
                if (targetResponse != null && targetResponse.getEntity() != null) {
                    Object targetEntity = targetResponse.getEntity();
                    List<Resource> targets = this.setupRelation(sourceResource, relationshipField, targetEntity, queryAdapter, resourceMap, entityMap, resourceMappingConfig);
                    loadedTargets.addAll(targets);
                    continue;
                }
                Nullable<Object> emptyData = Nullable.of(Iterable.class.isAssignableFrom(relationshipField.getType()) ? Collections.emptyList() : null);
                Relationship relationship = sourceResource.getRelationships().get(relationshipField.getJsonName());
                relationship.setData(emptyData);
            }
        } else {
            throw new RepositoryNotFoundException("no relationship repository found for " + resourceInformation.getResourceType() + "." + relationshipField.getUnderlyingName());
        }
        return loadedTargets;
    }

    private void setupRelationId(Resource sourceResource, ResourceField relationshipField, Object targetEntityId) {
        String relationshipName = relationshipField.getJsonName();
        Map<String, Relationship> relationships = sourceResource.getRelationships();
        Relationship relationship = relationships.get(relationshipName);
        String oppositeType = relationshipField.getOppositeResourceType();
        RegistryEntry entry = Objects.requireNonNull(this.resourceRegistry.getEntry(oppositeType));
        ResourceInformation targetResourceInformation = entry.getResourceInformation();
        if (targetEntityId instanceof Iterable) {
            ArrayList<ResourceIdentifier> targetIds = new ArrayList<ResourceIdentifier>();
            for (Object targetElementId : (Iterable)targetEntityId) {
                targetIds.add(this.util.idToResourceId(targetResourceInformation, targetElementId));
            }
            relationship.setData(Nullable.of(targetIds));
        } else {
            ResourceIdentifier targetResourceId = this.util.idToResourceId(targetResourceInformation, targetEntityId);
            relationship.setData(Nullable.of(targetResourceId));
        }
    }

    private List<Resource> setupRelation(Resource sourceResource, ResourceField relationshipField, Object targetEntity, QueryAdapter queryAdapter, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, ResourceMappingConfig resourceMappingConfig) {
        String relationshipName = relationshipField.getJsonName();
        Map<String, Relationship> relationships = sourceResource.getRelationships();
        Relationship relationship = relationships.get(relationshipName);
        if (targetEntity instanceof Iterable) {
            ArrayList<Resource> targets = new ArrayList<Resource>();
            for (Object targetElement : (Iterable)targetEntity) {
                Resource targetResource = this.mergeResource(targetElement, queryAdapter, resourceMap, entityMap, resourceMappingConfig);
                targets.add(targetResource);
            }
            relationship.setData(Nullable.of(this.util.toIds(targets)));
            return targets;
        }
        Resource targetResource = this.mergeResource(targetEntity, queryAdapter, resourceMap, entityMap, resourceMappingConfig);
        relationship.setData(Nullable.of(targetResource.toIdentifier()));
        return Collections.singletonList(targetResource);
    }

    private Resource mergeResource(Object targetEntity, QueryAdapter queryAdapter, Map<ResourceIdentifier, Resource> resourceMap, Map<ResourceIdentifier, Object> entityMap, ResourceMappingConfig resourceMappingConfig) {
        Resource targetResource = this.resourceMapper.toData(targetEntity, queryAdapter, resourceMappingConfig);
        ResourceIdentifier targetId = targetResource.toIdentifier();
        if (!resourceMap.containsKey(targetId)) {
            resourceMap.put(targetId, targetResource);
        } else {
            targetResource = resourceMap.get(targetId);
        }
        if (!(targetEntity instanceof Resource)) {
            entityMap.put(targetId, targetEntity);
        }
        return targetResource;
    }

    private List<Serializable> getIds(Collection<Resource> resources, ResourceInformation resourceInformation) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>();
        for (Resource resource : resources) {
            Serializable id = resourceInformation.parseIdString(resource.getId());
            ids.add(id);
        }
        return ids;
    }

    class PopulatedCache {
        private HashSet<String> processed = new HashSet();

        PopulatedCache() {
        }

        public void markProcessed(Resource resource, ResourceField field) {
            String key = this.getKey(resource, field);
            this.processed.add(key);
        }

        public Collection<Resource> filterProcessed(Collection<Resource> resources, ResourceField field) {
            ArrayList<Resource> result = new ArrayList<Resource>();
            for (Resource resource : resources) {
                if (this.wasProcessed(resource, field)) continue;
                result.add(resource);
                this.markProcessed(resource, field);
            }
            return result;
        }

        public boolean wasProcessed(Resource resource, ResourceField field) {
            String key = this.getKey(resource, field);
            return this.processed.contains(key);
        }

        private String getKey(Resource resource, ResourceField field) {
            return IncludeLookupSetter.this.resourceRegistry.getBaseResourceInformation(resource.getType()).getResourceType() + "@" + resource.getId() + "@" + field.getUnderlyingName();
        }
    }
}

