/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PropertyException;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.parser.ParserException;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.QuerySpecDeserializer;
import io.crnk.core.queryspec.QuerySpecDeserializerContext;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.resource.RestrictedQueryParamsMembers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQuerySpecDeserializer
implements QuerySpecDeserializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultQuerySpecDeserializer.class);
    private TypeParser typeParser;
    private FilterOperator defaultOperator = FilterOperator.EQ;
    private Set<FilterOperator> supportedOperators = new HashSet<FilterOperator>();
    private ResourceRegistry resourceRegistry;
    private boolean allowUnknownAttributes = false;
    private boolean enforceDotPathSeparator = false;
    private boolean ignoreParseExceptions;
    private boolean allowUnknownParameters = false;

    public DefaultQuerySpecDeserializer() {
        this.supportedOperators.add(FilterOperator.LIKE);
        this.supportedOperators.add(FilterOperator.EQ);
        this.supportedOperators.add(FilterOperator.NEQ);
        this.supportedOperators.add(FilterOperator.GT);
        this.supportedOperators.add(FilterOperator.GE);
        this.supportedOperators.add(FilterOperator.LT);
        this.supportedOperators.add(FilterOperator.LE);
    }

    public boolean getEnforceDotPathSeparator() {
        return this.enforceDotPathSeparator;
    }

    public void setEnforceDotPathSeparator(boolean enforceDotPathSeparator) {
        this.enforceDotPathSeparator = enforceDotPathSeparator;
    }

    public boolean getAllowUnknownAttributes() {
        return this.allowUnknownAttributes;
    }

    public void setAllowUnknownAttributes(boolean allowUnknownAttributes) {
        this.allowUnknownAttributes = allowUnknownAttributes;
    }

    public FilterOperator getDefaultOperator() {
        return this.defaultOperator;
    }

    public void setDefaultOperator(FilterOperator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public Set<FilterOperator> getSupportedOperators() {
        return this.supportedOperators;
    }

    public void addSupportedOperator(FilterOperator supportedOperator) {
        this.supportedOperators.add(supportedOperator);
    }

    @Override
    public void init(QuerySpecDeserializerContext ctx) {
        this.resourceRegistry = ctx.getResourceRegistry();
        this.typeParser = ctx.getTypeParser();
    }

    protected QuerySpec createQuerySpec(ResourceInformation resourceInformation) {
        return new QuerySpec(resourceInformation);
    }

    @Override
    public QuerySpec deserialize(ResourceInformation resourceInformation, Map<String, Set<String>> parameterMap) {
        QuerySpec rootQuerySpec = this.createQuerySpec(resourceInformation);
        List<Parameter> parameters = this.parseParameters(parameterMap, resourceInformation);
        HashMap<String, Set<String>> pageParameters = new HashMap<String, Set<String>>();
        block7: for (Parameter parameter : parameters) {
            QuerySpec querySpec = rootQuerySpec;
            if (parameter.resourceInformation != null && (querySpec = rootQuerySpec.getQuerySpec(parameter.resourceInformation)) == null) {
                querySpec = rootQuerySpec.getOrCreateQuerySpec(parameter.resourceInformation);
            }
            switch (parameter.paramType) {
                case sort: {
                    this.deserializeSort(querySpec, parameter);
                    continue block7;
                }
                case filter: {
                    this.deserializeFilter(querySpec, parameter);
                    continue block7;
                }
                case include: {
                    this.deserializeIncludes(querySpec, parameter);
                    continue block7;
                }
                case fields: {
                    this.deserializeFields(querySpec, parameter);
                    continue block7;
                }
                case page: {
                    pageParameters.put(parameter.pageParameter, parameter.getValues());
                    continue block7;
                }
            }
            this.deserializeUnknown(querySpec, parameter);
        }
        if (resourceInformation.getPagingBehavior() == null && !pageParameters.isEmpty()) {
            throw new IllegalStateException("Instance of PagingBehavior must be provided");
        }
        if (resourceInformation.getPagingBehavior() != null) {
            rootQuerySpec.setPagingSpec((PagingSpec)resourceInformation.getPagingBehavior().deserialize(pageParameters));
        }
        return rootQuerySpec;
    }

    private void deserializeIncludes(QuerySpec querySpec, Parameter parameter) {
        for (String values : parameter.values) {
            for (String value : this.splitValues(values)) {
                List<String> attributePath = this.splitAttributePath(value, parameter);
                querySpec.includeRelation(attributePath);
            }
        }
    }

    private String[] splitValues(String values) {
        return values.split(",");
    }

    protected void deserializeFields(QuerySpec querySpec, Parameter parameter) {
        for (String values : parameter.values) {
            for (String value : this.splitValues(values)) {
                List<String> attributePath = this.splitAttributePath(value, parameter);
                querySpec.includeField(attributePath);
            }
        }
    }

    protected void deserializeFilter(QuerySpec querySpec, Parameter parameter) {
        Class<?> attributeType = this.getAttributeType(querySpec, parameter.attributePath);
        HashSet<Object> typedValues = new HashSet<Object>();
        for (String stringValue : parameter.values) {
            try {
                Object value = this.typeParser.parse(stringValue, attributeType);
                typedValues.add(value);
            }
            catch (ParserException e) {
                if (this.ignoreParseExceptions) {
                    typedValues.add(stringValue);
                    LOGGER.debug("failed to parse {}", (Object)parameter);
                    continue;
                }
                throw new ParametersDeserializationException(parameter.toString(), e);
            }
        }
        HashSet<Object> value = typedValues.size() == 1 ? typedValues.iterator().next() : typedValues;
        querySpec.addFilter(new FilterSpec(parameter.attributePath, parameter.operator, value));
    }

    protected Class<?> getAttributeType(QuerySpec querySpec, List<String> attributePath) {
        try {
            if (attributePath == null) {
                return String.class;
            }
            Class<?> current = querySpec.getResourceClass();
            for (String propertyName : attributePath) {
                current = this.getAttributeType(current, propertyName);
            }
            return current;
        }
        catch (PropertyException e) {
            if (this.allowUnknownAttributes) {
                return String.class;
            }
            throw e;
        }
    }

    protected Class<?> getAttributeType(Class<?> clazz, String propertyName) {
        RegistryEntry entry;
        ResourceInformation resourceInformation;
        ResourceField field;
        if (this.resourceRegistry.hasEntry(clazz) && (field = (resourceInformation = (entry = this.resourceRegistry.getEntryForClass(clazz)).getResourceInformation()).findFieldByName(propertyName)) != null) {
            return field.getType();
        }
        return PropertyUtils.getPropertyClass(clazz, propertyName);
    }

    private void deserializeSort(QuerySpec querySpec, Parameter parameter) {
        for (String values : parameter.values) {
            for (String value : this.splitValues(values)) {
                boolean desc = value.startsWith("-");
                if (desc) {
                    value = value.substring(1);
                }
                List<String> attributePath = this.splitAttributePath(value, parameter);
                Direction dir = desc ? Direction.DESC : Direction.ASC;
                querySpec.addSort(new SortSpec(attributePath, dir));
            }
        }
    }

    protected void deserializeUnknown(QuerySpec querySpec, Parameter parameter) {
        if (!this.allowUnknownParameters) {
            throw new ParametersDeserializationException(parameter.name);
        }
    }

    private List<Parameter> parseParameters(Map<String, Set<String>> params, ResourceInformation rootResourceInformation) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Set<Map.Entry<String, Set<String>>> entrySet = params.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            list.add(this.parseParameter(entry.getKey(), entry.getValue(), rootResourceInformation));
        }
        return list;
    }

    private Parameter parseParameter(String parameterName, Set<String> values, ResourceInformation rootResourceInformation) {
        RestrictedQueryParamsMembers paramType;
        int typeSep = parameterName.indexOf(91);
        String strParamType = typeSep != -1 ? parameterName.substring(0, typeSep) : parameterName;
        try {
            paramType = RestrictedQueryParamsMembers.valueOf(strParamType.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            paramType = RestrictedQueryParamsMembers.unknown;
        }
        List<String> elements = this.parseParameterNameArguments(parameterName, typeSep);
        Parameter param = new Parameter();
        param.name = parameterName;
        param.paramType = paramType;
        param.strParamType = strParamType;
        param.values = values;
        if (paramType == RestrictedQueryParamsMembers.filter && elements.size() >= 1) {
            this.parseFilterParameterName(param, elements, rootResourceInformation);
        } else if (paramType == RestrictedQueryParamsMembers.page && elements.size() == 1) {
            param.resourceInformation = rootResourceInformation;
            param.pageParameter = elements.get(0);
        } else if (paramType == RestrictedQueryParamsMembers.page && elements.size() == 2) {
            param.resourceInformation = this.getResourceInformation(elements.get(0), parameterName);
            param.pageParameter = elements.get(1);
        } else if (paramType == RestrictedQueryParamsMembers.unknown) {
            param.resourceInformation = null;
        } else if (elements.size() == 1) {
            param.resourceInformation = this.getResourceInformation(elements.get(0), parameterName);
        } else {
            param.resourceInformation = rootResourceInformation;
        }
        if (param.operator == null) {
            param.operator = this.defaultOperator;
        }
        return param;
    }

    private List<String> parseParameterNameArguments(String parameterName, int typeSep) {
        ArrayList<String> elements = new ArrayList<String>();
        if (typeSep != -1) {
            String parameterNameSuffix = parameterName.substring(typeSep);
            if (!parameterNameSuffix.startsWith("[") || !parameterNameSuffix.endsWith("]")) {
                throw new ParametersDeserializationException("expected not [ resp. ] in legacy " + parameterName);
            }
            elements.addAll(Arrays.asList(parameterNameSuffix.substring(1, parameterNameSuffix.length() - 1).split("\\]\\[")));
        }
        return elements;
    }

    private void parseFilterParameterName(Parameter param, List<String> elements, ResourceInformation rootResourceInformation) {
        this.parseFilterOperator(param, elements);
        if (elements.isEmpty()) {
            throw new ParametersDeserializationException("failed to parse " + param.name + ", expected " + "([resourceType])[attr1.attr2]([operator])");
        }
        if (this.enforceDotPathSeparator && elements.size() > 2) {
            throw new ParametersDeserializationException("failed to parse " + param.name + ", expected ([resourceType])[attr1.attr2]([operator])");
        }
        if (this.enforceDotPathSeparator && elements.size() == 2) {
            param.resourceInformation = this.getResourceInformation(elements.get(0), param.name);
            param.attributePath = Arrays.asList(elements.get(1).split("\\."));
        } else if (this.enforceDotPathSeparator && elements.size() == 1) {
            param.resourceInformation = rootResourceInformation;
            param.attributePath = Arrays.asList(elements.get(0).split("\\."));
        } else {
            this.legacyParseFilterParameterName(param, elements, rootResourceInformation);
        }
    }

    private void legacyParseFilterParameterName(Parameter param, List<String> elements, ResourceInformation rootResourceInformation) {
        if (this.isResourceType(elements.get(0))) {
            param.resourceInformation = this.getResourceInformation(elements.get(0), param.name);
            elements.remove(0);
        } else {
            param.resourceInformation = rootResourceInformation;
        }
        param.attributePath = new ArrayList();
        for (String element : elements) {
            param.attributePath.addAll(Arrays.asList(element.split("\\.")));
        }
    }

    private void parseFilterOperator(Parameter param, List<String> elements) {
        String lastElement = elements.get(elements.size() - 1);
        param.operator = this.findOperator(lastElement);
        if (param.operator != null) {
            elements.remove(elements.size() - 1);
        } else {
            param.operator = this.defaultOperator;
        }
    }

    private boolean isResourceType(String resourceType) {
        return this.resourceRegistry.getEntry(resourceType) != null;
    }

    private FilterOperator findOperator(String lastElement) {
        for (FilterOperator op : this.supportedOperators) {
            if (!op.getName().equalsIgnoreCase(lastElement)) continue;
            return op;
        }
        return null;
    }

    private ResourceInformation getResourceInformation(String resourceType, String parameterName) {
        RegistryEntry registryEntry = this.resourceRegistry.getEntry(resourceType);
        if (registryEntry == null) {
            throw new ParametersDeserializationException("failed to parse parameter " + parameterName + ", resourceType=" + resourceType + " not found");
        }
        return registryEntry.getResourceInformation();
    }

    private List<String> splitAttributePath(String pathString, Parameter param) {
        return Arrays.asList(pathString.split("\\."));
    }

    public boolean isIgnoreParseExceptions() {
        return this.ignoreParseExceptions;
    }

    public void setIgnoreParseExceptions(boolean ignoreParseExceptions) {
        this.ignoreParseExceptions = ignoreParseExceptions;
    }

    public boolean isAllowUnknownParameters() {
        return this.allowUnknownParameters;
    }

    public void setAllowUnknownParameters(boolean allowUnknownParameters) {
        this.allowUnknownParameters = allowUnknownParameters;
    }

    public class Parameter {
        private String pageParameter;
        private String name;
        private RestrictedQueryParamsMembers paramType;
        private String strParamType;
        private ResourceInformation resourceInformation;
        private FilterOperator operator;
        private List<String> attributePath;
        private Set<String> values;

        public Long getLongValue() {
            if (this.values.size() != 1) {
                throw new ParametersDeserializationException("expected a Long for " + this.toString());
            }
            try {
                return Long.parseLong(this.values.iterator().next());
            }
            catch (NumberFormatException e) {
                throw new ParametersDeserializationException("expected a Long for " + this.toString());
            }
        }

        public String toString() {
            return this.name + "=" + this.values;
        }

        public String getPageParameter() {
            return this.pageParameter;
        }

        public String getName() {
            return this.name;
        }

        public RestrictedQueryParamsMembers getParamType() {
            return this.paramType;
        }

        public String getStrParamType() {
            return this.strParamType;
        }

        public ResourceInformation getResourceInformation() {
            return this.resourceInformation;
        }

        public FilterOperator getOperator() {
            return this.operator;
        }

        public List<String> getAttributePath() {
            return this.attributePath;
        }

        public Set<String> getValues() {
            return this.values;
        }
    }
}

