/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpecDeserializer;
import io.crnk.core.queryspec.QuerySpecDeserializerContext;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import java.util.Map;
import java.util.Set;

public class QuerySpecAdapterBuilder
implements QueryAdapterBuilder {
    private final HttpRequestContextProvider requestContextProvider;
    private QuerySpecDeserializer querySpecDeserializer;
    private ResourceRegistry resourceRegistry;

    public QuerySpecAdapterBuilder(QuerySpecDeserializer querySpecDeserializer, final ModuleRegistry moduleRegistry) {
        this.querySpecDeserializer = querySpecDeserializer;
        this.resourceRegistry = moduleRegistry.getResourceRegistry();
        this.requestContextProvider = moduleRegistry.getHttpRequestContextProvider();
        this.querySpecDeserializer.init(new QuerySpecDeserializerContext(){

            @Override
            public ResourceRegistry getResourceRegistry() {
                return QuerySpecAdapterBuilder.this.resourceRegistry;
            }

            @Override
            public TypeParser getTypeParser() {
                return moduleRegistry.getTypeParser();
            }
        });
    }

    @Override
    public QueryAdapter build(ResourceInformation resourceInformation, Map<String, Set<String>> parameters) {
        QuerySpecAdapter adapter = new QuerySpecAdapter(this.querySpecDeserializer.deserialize(resourceInformation, parameters), this.resourceRegistry);
        HttpRequestContext requestContext = this.requestContextProvider.getRequestContext();
        if (requestContext != null) {
            adapter.setCompactMode(Boolean.parseBoolean(requestContext.getRequestHeader("Crnk-Compact")));
        }
        return adapter;
    }
}

