/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.internal.CoreModule;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistryBuilder;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.http.HttpRequestProcessorImpl;
import io.crnk.core.engine.internal.http.JsonApiRequestProcessor;
import io.crnk.core.engine.internal.jackson.JacksonModule;
import io.crnk.core.engine.internal.registry.ResourceRegistryImpl;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.NullPropertiesProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.registry.DefaultResourceRegistryPart;
import io.crnk.core.engine.registry.HierarchicalResourceRegistryPart;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.registry.ResourceRegistryPartBase;
import io.crnk.core.engine.url.ConstantServiceUrlProvider;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.SimpleModule;
import io.crnk.core.module.discovery.DefaultServiceDiscoveryFactory;
import io.crnk.core.module.discovery.FallbackServiceDiscoveryFactory;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.module.discovery.ServiceDiscoveryFactory;
import io.crnk.core.queryspec.DefaultQuerySpecDeserializer;
import io.crnk.core.queryspec.QuerySpecDeserializer;
import io.crnk.core.queryspec.internal.QuerySpecAdapterBuilder;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.repository.Repository;
import io.crnk.legacy.internal.QueryParamsAdapterBuilder;
import io.crnk.legacy.locator.JsonServiceLocator;
import io.crnk.legacy.locator.SampleJsonServiceLocator;
import io.crnk.legacy.queryParams.QueryParamsBuilder;
import io.crnk.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.crnk.legacy.repository.annotations.JsonApiResourceRepository;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CrnkBoot {
    private final ModuleRegistry moduleRegistry = new ModuleRegistry();
    private ObjectMapper objectMapper;
    private QueryParamsBuilder queryParamsBuilder;
    private QuerySpecDeserializer querySpecDeserializer;
    private boolean configured;
    private JsonServiceLocator serviceLocator = new SampleJsonServiceLocator();
    private ResourceRegistry resourceRegistry;
    private HttpRequestProcessorImpl requestDispatcher;
    private PropertiesProvider propertiesProvider = new NullPropertiesProvider();
    private ServiceDiscoveryFactory serviceDiscoveryFactory = new DefaultServiceDiscoveryFactory();
    private ServiceDiscovery serviceDiscovery;
    private DocumentMapper documentMapper;
    private List<Module> registeredModules = new ArrayList<Module>();
    private Long defaultPageLimit = null;
    private Long maxPageLimit = null;
    private Boolean allowUnknownAttributes;
    private Boolean allowUnknownParameters;
    private List<PagingBehavior> pagingBehaviors;

    private static String buildServiceUrl(String resourceDefaultDomain, String webPathPrefix) {
        return resourceDefaultDomain + (webPathPrefix != null ? webPathPrefix : "");
    }

    public void setServiceDiscoveryFactory(ServiceDiscoveryFactory factory) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNull("serviceDiscovery already initialized", this.serviceDiscovery);
        this.serviceDiscoveryFactory = factory;
    }

    public void setQueryParamsBuilds(QueryParamsBuilder queryParamsBuilder) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNotNull("A query params builder must be provided, but is null", queryParamsBuilder);
        this.queryParamsBuilder = queryParamsBuilder;
        this.querySpecDeserializer = null;
    }

    public void setServiceLocator(JsonServiceLocator serviceLocator) {
        this.checkNotConfiguredYet();
        this.serviceLocator = serviceLocator;
    }

    public void addModule(Module module) {
        this.checkNotConfiguredYet();
        this.setupInstance(module);
        this.registeredModules.add(module);
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.checkNotConfiguredYet();
        this.moduleRegistry.getHttpRequestContextProvider().setServiceUrlProvider(serviceUrlProvider);
    }

    private void checkNotConfiguredYet() {
        if (this.configured) {
            throw new IllegalStateException("cannot further modify CrnkFeature once configured/initialized by JAX-RS");
        }
    }

    public void boot() {
        this.checkNotConfiguredYet();
        this.configured = true;
        this.moduleRegistry.setPropertiesProvider(this.propertiesProvider);
        this.setupServiceUrlProvider();
        this.setupServiceDiscovery();
        this.setupQuerySpecDeserializer();
        this.setupPagingBehavior();
        this.bootDiscovery();
    }

    private void setupServiceDiscovery() {
        if (this.serviceDiscovery == null) {
            FallbackServiceDiscoveryFactory fallback = new FallbackServiceDiscoveryFactory(this.serviceDiscoveryFactory, this.serviceLocator, this.propertiesProvider);
            this.setServiceDiscovery(fallback.getInstance());
        }
    }

    private void bootDiscovery() {
        this.setupObjectMapper();
        this.addModules();
        this.setupComponents();
        ResourceRegistryPart rootPart = this.setupResourceRegistry();
        this.moduleRegistry.init(this.objectMapper);
        this.setupRepositories(rootPart);
        this.requestDispatcher = this.createRequestDispatcher(this.moduleRegistry.getExceptionMapperRegistry());
    }

    private void setupRepositories(ResourceRegistryPart rootPart) {
        for (RegistryEntry entry : this.moduleRegistry.getRegistryEntries()) {
            rootPart.addEntry(entry);
        }
    }

    private ResourceRegistryPart setupResourceRegistry() {
        ResourceRegistryPartBase rootPart;
        Map<String, ResourceRegistryPart> registryParts = this.moduleRegistry.getRegistryParts();
        if (registryParts.isEmpty()) {
            rootPart = new DefaultResourceRegistryPart();
        } else {
            HierarchicalResourceRegistryPart hierarchialPart = new HierarchicalResourceRegistryPart();
            for (Map.Entry<String, ResourceRegistryPart> entry : registryParts.entrySet()) {
                hierarchialPart.putPart(entry.getKey(), entry.getValue());
            }
            if (!registryParts.containsKey("")) {
                this.moduleRegistry.getContext().addRegistryPart("", new DefaultResourceRegistryPart());
            }
            rootPart = hierarchialPart;
        }
        this.resourceRegistry = new ResourceRegistryImpl(rootPart, this.moduleRegistry);
        return rootPart;
    }

    private void setupObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.findAndRegisterModules();
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.moduleRegistry.setObjectMapper(this.objectMapper);
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        return this.moduleRegistry.getExceptionMapperRegistry();
    }

    private HttpRequestProcessorImpl createRequestDispatcher(ExceptionMapperRegistry exceptionMapperRegistry) {
        ControllerRegistryBuilder controllerRegistryBuilder = this.newControllerRegistryBuilder(this.resourceRegistry, this.moduleRegistry.getTypeParser(), this.objectMapper, this.propertiesProvider, this.moduleRegistry.getContext().getResourceFilterDirectory(), this.moduleRegistry.getResourceModificationFilters());
        ControllerRegistry controllerRegistry = controllerRegistryBuilder.build();
        this.documentMapper = controllerRegistryBuilder.getDocumentMapper();
        QueryAdapterBuilder queryAdapterBuilder = this.queryParamsBuilder != null ? new QueryParamsAdapterBuilder(this.queryParamsBuilder, this.moduleRegistry) : new QuerySpecAdapterBuilder(this.querySpecDeserializer, this.moduleRegistry);
        return new HttpRequestProcessorImpl(this.moduleRegistry, controllerRegistry, exceptionMapperRegistry, queryAdapterBuilder);
    }

    protected ControllerRegistryBuilder newControllerRegistryBuilder(ResourceRegistry resourceRegistry, TypeParser typeParser, ObjectMapper objectMapper, PropertiesProvider propertiesProvider, ResourceFilterDirectory resourceFilterDirectory, List<ResourceModificationFilter> modificationFilters) {
        return new ControllerRegistryBuilder(resourceRegistry, this.moduleRegistry.getTypeParser(), objectMapper, propertiesProvider, this.moduleRegistry.getContext().getResourceFilterDirectory(), this.moduleRegistry.getResourceModificationFilters());
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    private void setupComponents() {
        Annotation annotation;
        SimpleModule module = new SimpleModule("discovery"){

            @Override
            public void setupModule(Module.ModuleContext context) {
                this.addHttpRequestProcessor(new JsonApiRequestProcessor(context));
                super.setupModule(context);
            }
        };
        for (JsonApiExceptionMapper jsonApiExceptionMapper : this.getInstancesByType(JsonApiExceptionMapper.class)) {
            module.addExceptionMapper(jsonApiExceptionMapper);
        }
        for (DocumentFilter documentFilter : this.getInstancesByType(DocumentFilter.class)) {
            module.addFilter(documentFilter);
        }
        for (Object object : this.getInstancesByType(Repository.class)) {
            module.addRepository(object);
        }
        for (Object object : this.serviceDiscovery.getInstancesByAnnotation(JsonApiResourceRepository.class)) {
            annotation = ClassUtils.getAnnotation(object.getClass(), JsonApiResourceRepository.class).get();
            Class<?> resourceClass = annotation.value();
            module.addRepository(resourceClass, object);
        }
        for (Object object : this.serviceDiscovery.getInstancesByAnnotation(JsonApiRelationshipRepository.class)) {
            annotation = ClassUtils.getAnnotation(object.getClass(), JsonApiRelationshipRepository.class).get();
            module.addRepository(annotation.source(), annotation.target(), object);
        }
        this.moduleRegistry.addModule(module);
        this.moduleRegistry.addModule(new CoreModule());
    }

    private <T> List<T> getInstancesByType(Class<T> clazz) {
        List<T> instancesByType = this.serviceDiscovery.getInstancesByType(clazz);
        for (T instance : instancesByType) {
            this.setupInstance(instance);
        }
        return instancesByType;
    }

    private <T> void setupInstance(T instance) {
        if (instance instanceof HttpRequestContextAware) {
            HttpRequestContextAware aware = (HttpRequestContextAware)instance;
            aware.setHttpRequestContextProvider(this.moduleRegistry.getHttpRequestContextProvider());
        }
    }

    private void addModules() {
        for (Module module : this.registeredModules) {
            this.moduleRegistry.addModule(module);
        }
        boolean serializeLinksAsObjects = Boolean.parseBoolean(this.propertiesProvider.getProperty("crnk.config.serialize.object.links"));
        this.moduleRegistry.addModule(new JacksonModule(this.objectMapper, serializeLinksAsObjects, this.pagingBehaviors));
        List<Module> discoveredModules = this.getInstancesByType(Module.class);
        for (Module module : discoveredModules) {
            this.moduleRegistry.addModule(module);
        }
    }

    private void setupServiceUrlProvider() {
        String resourceDefaultDomain = this.propertiesProvider.getProperty("crnk.config.core.resource.domain");
        String webPathPrefix = this.getWebPathPrefix();
        if (resourceDefaultDomain != null) {
            String serviceUrl = CrnkBoot.buildServiceUrl(resourceDefaultDomain, webPathPrefix);
            this.moduleRegistry.getHttpRequestContextProvider().setServiceUrlProvider(new ConstantServiceUrlProvider(serviceUrl));
        }
    }

    public HttpRequestProcessorImpl getRequestDispatcher() {
        PreconditionUtil.assertNotNull("expected requestDispatcher", this.requestDispatcher);
        return this.requestDispatcher;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNull("ObjectMapper already set", this.objectMapper);
        this.objectMapper = objectMapper;
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.checkNotConfiguredYet();
        this.propertiesProvider = propertiesProvider;
    }

    @Deprecated
    public ServiceUrlProvider getDefaultServiceUrlProvider() {
        return this.getServiceUrlProvider();
    }

    @Deprecated
    public void setDefaultServiceUrlProvider(ServiceUrlProvider defaultServiceUrlProvider) {
        this.setServiceUrlProvider(defaultServiceUrlProvider);
    }

    public String getWebPathPrefix() {
        return this.propertiesProvider.getProperty("crnk.config.web.path.prefix");
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.moduleRegistry.getServiceDiscovery();
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        PreconditionUtil.assertNull("already set", this.serviceDiscovery);
        this.serviceDiscovery = serviceDiscovery;
        this.moduleRegistry.setServiceDiscovery(serviceDiscovery);
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        PreconditionUtil.assertNull("Setting the default page limit requires using the QuerySpecDeserializer, but it is null. Are you using QueryParams instead?", this.queryParamsBuilder);
        this.defaultPageLimit = defaultPageLimit;
    }

    public void setMaxPageLimit(Long maxPageLimit) {
        PreconditionUtil.assertNull("Setting the max page limit requires using the QuerySpecDeserializer, but it is null. Are you using QueryParams instead?", this.queryParamsBuilder);
        this.maxPageLimit = maxPageLimit;
    }

    public void setAllowUnknownAttributes() {
        PreconditionUtil.assertNull("Allow unknown attributes requires using the QuerySpecDeserializer, but it is null.", this.queryParamsBuilder);
        this.allowUnknownAttributes = true;
    }

    public void setAllowUnknownParameters() {
        PreconditionUtil.assertNull("Allow unknown parameters requires using the QuerySpecDeserializer, but it is null.", this.queryParamsBuilder);
        this.allowUnknownParameters = true;
    }

    public ModuleRegistry getModuleRegistry() {
        return this.moduleRegistry;
    }

    public QuerySpecDeserializer getQuerySpecDeserializer() {
        this.setupQuerySpecDeserializer();
        return this.querySpecDeserializer;
    }

    private void setupQuerySpecDeserializer() {
        if (this.querySpecDeserializer == null) {
            this.setupServiceDiscovery();
            List<QuerySpecDeserializer> list = this.serviceDiscovery.getInstancesByType(QuerySpecDeserializer.class);
            this.querySpecDeserializer = list.isEmpty() ? new DefaultQuerySpecDeserializer() : list.get(0);
        }
        if (this.querySpecDeserializer instanceof DefaultQuerySpecDeserializer) {
            String strAllow;
            if (this.allowUnknownAttributes == null && (strAllow = this.propertiesProvider.getProperty("crnk.config.resource.request.allowUnknownAttributes")) != null) {
                this.allowUnknownAttributes = Boolean.parseBoolean(strAllow);
            }
            if (this.allowUnknownAttributes != null) {
                ((DefaultQuerySpecDeserializer)this.querySpecDeserializer).setAllowUnknownAttributes(this.allowUnknownAttributes);
            }
            if (this.allowUnknownParameters == null && (strAllow = this.propertiesProvider.getProperty("crnk.config.resource.request.allowUnknownParameters")) != null) {
                this.allowUnknownParameters = Boolean.parseBoolean(strAllow);
            }
            if (this.allowUnknownParameters != null) {
                ((DefaultQuerySpecDeserializer)this.querySpecDeserializer).setAllowUnknownParameters(this.allowUnknownParameters);
            }
        }
    }

    private void setupPagingBehavior() {
        if (this.pagingBehaviors == null) {
            this.setupServiceDiscovery();
            this.pagingBehaviors = new ArrayList<PagingBehavior>();
            this.pagingBehaviors.addAll(this.serviceDiscovery.getInstancesByType(PagingBehavior.class));
            if (this.pagingBehaviors.isEmpty()) {
                this.pagingBehaviors.add(new OffsetLimitPagingBehavior());
            }
        }
        for (PagingBehavior pagingBehavior : this.pagingBehaviors) {
            if (!(pagingBehavior instanceof OffsetLimitPagingBehavior)) continue;
            if (this.defaultPageLimit != null) {
                ((OffsetLimitPagingBehavior)pagingBehavior).setDefaultLimit(this.defaultPageLimit);
            }
            if (this.maxPageLimit == null) continue;
            ((OffsetLimitPagingBehavior)pagingBehavior).setMaxPageLimit(this.maxPageLimit);
        }
    }

    public void setQuerySpecDeserializer(QuerySpecDeserializer querySpecDeserializer) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNotNull("A query spec deserializer must be provided, but is null", querySpecDeserializer);
        this.querySpecDeserializer = querySpecDeserializer;
        this.queryParamsBuilder = null;
    }

    public boolean isNullDataResponseEnabled() {
        return Boolean.parseBoolean(this.propertiesProvider.getProperty("crnk.config.null.data.response.enabled"));
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.moduleRegistry.getHttpRequestContextProvider().getServiceUrlProvider();
    }

    public List<PagingBehavior> getPagingBehaviors() {
        return this.pagingBehaviors;
    }
}

