/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.http;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.url.ServiceUrlProvider;

public class HttpRequestContextProvider {
    private ThreadLocal<HttpRequestContext> threadLocal = new ThreadLocal();
    private ServiceUrlProvider serviceUrlProvider = new ServiceUrlProvider(){

        @Override
        public String getUrl() {
            HttpRequestContext request = (HttpRequestContext)HttpRequestContextProvider.this.threadLocal.get();
            if (request == null) {
                return null;
            }
            return request.getBaseUrl();
        }
    };

    public HttpRequestContext getRequestContext() {
        return this.threadLocal.get();
    }

    public void onRequestStarted(HttpRequestContext request) {
        this.threadLocal.set(request);
    }

    public void onRequestFinished() {
        this.threadLocal.remove();
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.serviceUrlProvider = serviceUrlProvider;
    }
}

