/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.SerializerUtil;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.links.RelatedLinksInformation;
import io.crnk.core.resource.links.SelfLinksInformation;
import io.crnk.core.resource.list.LinksContainer;
import io.crnk.core.resource.meta.MetaContainer;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.legacy.queryParams.include.Inclusion;
import io.crnk.legacy.queryParams.params.IncludedFieldsParams;
import io.crnk.legacy.queryParams.params.IncludedRelationsParams;
import io.crnk.legacy.queryParams.params.TypedParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DocumentMapperUtil {
    private ResourceRegistry resourceRegistry;
    private ObjectMapper objectMapper;
    private static SerializerUtil serializerUtil;

    public DocumentMapperUtil(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider) {
        this.resourceRegistry = resourceRegistry;
        this.objectMapper = objectMapper;
        boolean serializeLinksAsObjects = Boolean.parseBoolean(propertiesProvider.getProperty("crnk.config.serialize.object.links"));
        serializerUtil = new SerializerUtil(serializeLinksAsObjects);
    }

    protected static List<ResourceField> getRequestedFields(ResourceInformation resourceInformation, QueryAdapter queryAdapter, List<ResourceField> fields, boolean relation) {
        IncludedFieldsParams includedFields;
        TypedParams<IncludedFieldsParams> includedFieldsSet = queryAdapter != null ? queryAdapter.getIncludedFields() : null;
        IncludedFieldsParams includedFieldsParams = includedFields = includedFieldsSet != null ? includedFieldsSet.getParams().get(resourceInformation.getResourceType()) : null;
        if (DocumentMapperUtil.noResourceIncludedFieldsSpecified(includedFields)) {
            return fields;
        }
        return DocumentMapperUtil.computeRequestedFields(includedFields, relation, queryAdapter, resourceInformation, fields);
    }

    private static List<ResourceField> computeRequestedFields(IncludedFieldsParams includedFields, boolean relation, QueryAdapter queryAdapter, ResourceInformation resourceInformation, List<ResourceField> fields) {
        Set<String> includedFieldNames = includedFields.getParams();
        if (relation) {
            IncludedRelationsParams includedRelations;
            TypedParams<IncludedRelationsParams> includedRelationsSet = queryAdapter.getIncludedRelations();
            IncludedRelationsParams includedRelationsParams = includedRelations = includedRelationsSet != null ? includedRelationsSet.getParams().get(resourceInformation.getResourceType()) : null;
            if (includedRelations != null) {
                includedFieldNames = new HashSet<String>(includedFieldNames);
                for (Inclusion include : includedRelations.getParams()) {
                    includedFieldNames.add(include.getPath());
                }
            }
        }
        ArrayList<ResourceField> results = new ArrayList<ResourceField>();
        for (ResourceField field : fields) {
            if (!includedFieldNames.contains(field.getJsonName())) continue;
            results.add(field);
        }
        return results;
    }

    protected static boolean noResourceIncludedFieldsSpecified(IncludedFieldsParams typeIncludedFields) {
        return typeIncludedFields == null || typeIncludedFields.getParams().isEmpty();
    }

    public static <T> List<T> toList(Object entity) {
        if (entity instanceof List) {
            return (List)entity;
        }
        if (entity instanceof Iterable) {
            ArrayList result = new ArrayList();
            for (Object element : (Iterable)entity) {
                result.add(element);
            }
            return result;
        }
        return Collections.singletonList(entity);
    }

    public String getRelationshipLink(ResourceInformation resourceInformation, Object entity, ResourceField field, boolean related) {
        String resourceUrl = this.resourceRegistry.getResourceUrl(resourceInformation);
        String resourceId = this.getIdString(entity, resourceInformation);
        return resourceUrl + "/" + resourceId + (!related ? "/relationships/" : "/") + field.getJsonName();
    }

    public List<ResourceIdentifier> toResourceIds(Collection<?> entities) {
        ArrayList<ResourceIdentifier> results = new ArrayList<ResourceIdentifier>();
        for (Object entity : entities) {
            results.add(this.toResourceId(entity));
        }
        return results;
    }

    public ResourceIdentifier toResourceId(Object entity) {
        if (entity == null) {
            return null;
        }
        RegistryEntry entry = this.resourceRegistry.findEntry(entity.getClass());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        return resourceInformation.toResourceIdentifier(entity);
    }

    public String getIdString(Object entity, ResourceInformation resourceInformation) {
        ResourceField idField = resourceInformation.getIdField();
        Object sourceId = idField.getAccessor().getValue(entity);
        return resourceInformation.toIdString(sourceId);
    }

    public void setLinks(LinksContainer container, LinksInformation linksInformation, QueryAdapter queryAdapter) {
        ObjectNode links;
        if (linksInformation != null) {
            container.setLinks((ObjectNode)this.objectMapper.valueToTree((Object)linksInformation));
        }
        if (queryAdapter != null && queryAdapter.getCompactMode() && (links = container.getLinks()) != null) {
            links.remove("self");
            if (!links.fieldNames().hasNext()) {
                container.setLinks(null);
            }
        }
    }

    public void setMeta(MetaContainer container, MetaInformation metaInformation) {
        if (metaInformation != null) {
            container.setMeta((ObjectNode)this.objectMapper.valueToTree((Object)metaInformation));
        }
    }

    public ResourceInformation getResourceInformation(Class<?> dataClass) {
        return this.resourceRegistry.findEntry(dataClass).getResourceInformation();
    }

    public ResourceInformation getResourceInformation(String resourceType) {
        return this.resourceRegistry.getEntry(resourceType).getResourceInformation();
    }

    public String getSelfUrl(ResourceInformation resourceInformation, Object entity) {
        String resourceUrl = this.resourceRegistry.getResourceUrl(resourceInformation);
        return resourceUrl + "/" + this.getIdString(entity, resourceInformation);
    }

    public static SerializerUtil getSerializerUtil() {
        return serializerUtil;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected static class DefaultSelfRelatedLinksInformation
    implements SelfLinksInformation,
    RelatedLinksInformation {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String related;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String self;

        protected DefaultSelfRelatedLinksInformation() {
        }

        @Override
        public String getRelated() {
            return this.related;
        }

        @Override
        public void setRelated(String related) {
            this.related = related;
        }

        @Override
        public String getSelf() {
            return this.self;
        }

        @Override
        public void setSelf(String self) {
            this.self = self;
        }
    }
}

