/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.internal.information.resource.DefaultResourceFieldInformationProvider;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInformationProvider;
import io.crnk.core.engine.internal.jackson.ErrorDataDeserializer;
import io.crnk.core.engine.internal.jackson.ErrorDataSerializer;
import io.crnk.core.engine.internal.jackson.JacksonResourceFieldInformationProvider;
import io.crnk.core.engine.internal.jackson.LinksInformationSerializer;
import io.crnk.core.module.Module;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import java.util.Collections;
import java.util.List;

public class JacksonModule
implements io.crnk.core.module.Module {
    private static final String JSON_API_JACKSON_MODULE_NAME = "crnk";
    private final ObjectMapper objectMapper;
    private final boolean serializeLinksAsObjects;
    private final List<? extends PagingBehavior> pagingBehaviors;

    @Deprecated
    public JacksonModule(ObjectMapper objectMapper) {
        this(objectMapper, false, Collections.emptyList());
    }

    @Deprecated
    public JacksonModule(ObjectMapper objectMapper, boolean serializeLinksAsObjects) {
        this(objectMapper, serializeLinksAsObjects, Collections.emptyList());
    }

    public JacksonModule(ObjectMapper objectMapper, boolean serializeLinksAsObjects, List<? extends PagingBehavior> pagingBehaviors) {
        this.objectMapper = objectMapper;
        this.serializeLinksAsObjects = serializeLinksAsObjects;
        this.pagingBehaviors = pagingBehaviors;
    }

    @Override
    public String getModuleName() {
        return "jackson";
    }

    @Override
    public void setupModule(Module.ModuleContext context) {
        this.objectMapper.registerModule((Module)JacksonModule.createJacksonModule(this.serializeLinksAsObjects));
        DefaultResourceFieldInformationProvider defaultFieldProvider = new DefaultResourceFieldInformationProvider();
        JacksonResourceFieldInformationProvider jacksonFieldProvider = new JacksonResourceFieldInformationProvider();
        context.addResourceInformationBuilder(new DefaultResourceInformationProvider(context.getPropertiesProvider(), this.pagingBehaviors, defaultFieldProvider, jacksonFieldProvider));
    }

    public static SimpleModule createJacksonModule() {
        return JacksonModule.createJacksonModule(false);
    }

    public static SimpleModule createJacksonModule(boolean serializeLinksAsObjects) {
        SimpleModule simpleModule = new SimpleModule(JSON_API_JACKSON_MODULE_NAME, new Version(1, 0, 0, null, null, null));
        simpleModule.addSerializer((JsonSerializer)new ErrorDataSerializer());
        simpleModule.addDeserializer(ErrorData.class, (JsonDeserializer)new ErrorDataDeserializer());
        if (serializeLinksAsObjects) {
            simpleModule.addSerializer((JsonSerializer)new LinksInformationSerializer());
        }
        return simpleModule;
    }
}

