/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;

public class CollectionGet
extends ResourceIncludeField {
    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.GET.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        Result<JsonApiResponse> response;
        String resourceName = jsonPath.getElementName();
        RegistryEntry registryEntry = this.context.getResourceRegistry().getEntry(resourceName);
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        if (registryEntry == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        DocumentMappingConfig docummentMapperConfig = DocumentMappingConfig.create().setParameterProvider(parameterProvider);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository(parameterProvider);
        if (jsonPath.getIds() == null || jsonPath.getIds().getIds().isEmpty()) {
            this.logger.debug("finding {}", (Object)queryAdapter);
            response = resourceRepository.findAll(queryAdapter);
        } else {
            Class<?> idType = registryEntry.getResourceInformation().getIdField().getType();
            Iterable<?> parsedIds = this.context.getTypeParser().parse(jsonPath.getIds().getIds(), idType);
            this.logger.debug("finding {} with ids {}", (Object)queryAdapter, parsedIds);
            response = resourceRepository.findAll(parsedIds, queryAdapter);
        }
        return response.merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, docummentMapperConfig)).map(this::toResponse);
    }

    public Response toResponse(Document document) {
        if (!document.getData().isPresent()) {
            document.setData(Nullable.nullValue());
        }
        this.logger.debug("mapping {} to response");
        return new Response(document, 200);
    }
}

