/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.FieldPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathIds;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;

public class FieldResourceGet
extends ResourceIncludeField {
    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return !jsonPath.isCollection() && FieldPath.class.equals(jsonPath.getClass()) && HttpMethod.GET.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        PathIds resourceIds = jsonPath.getIds();
        String resourceName = jsonPath.getResourceType();
        String elementName = jsonPath.getElementName();
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry registryEntry = resourceRegistry.getEntry(resourceName);
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        Serializable castedResourceId = this.getResourceId(resourceIds, registryEntry);
        ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(elementName);
        FieldResourceGet.verifyFieldNotNull(relationshipField, elementName);
        Class<?> baseRelationshipFieldClass = relationshipField.getType();
        DocumentMappingConfig docummentMapperConfig = DocumentMappingConfig.create().setParameterProvider(parameterProvider);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = registryEntry.getRelationshipRepository(relationshipField, parameterProvider);
        Result<JsonApiResponse> response = Iterable.class.isAssignableFrom(baseRelationshipFieldClass) ? relationshipRepositoryForClass.findManyTargets(castedResourceId, relationshipField, queryAdapter) : relationshipRepositoryForClass.findOneTarget(castedResourceId, relationshipField, queryAdapter);
        return response.merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, docummentMapperConfig)).map(this::toResponse);
    }

    public Response toResponse(Document document) {
        if (!document.getData().isPresent()) {
            document.setData(Nullable.nullValue());
        }
        return new Response(document, 200);
    }

    private Serializable getResourceId(PathIds resourceIds, RegistryEntry registryEntry) {
        String resourceId = resourceIds.getIds().get(0);
        Class<?> idClass = registryEntry.getResourceInformation().getIdField().getType();
        TypeParser typeParser = this.context.getTypeParser();
        return (Serializable)typeParser.parse(resourceId, idClass);
    }
}

