/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.filter.ResourceRelationshipModificationType;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.FieldPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathIds;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldResourcePost
extends ResourceUpsert {
    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        PreconditionUtil.assertNotNull("path cannot be null", jsonPath);
        return !jsonPath.isCollection() && FieldPath.class.equals(jsonPath.getClass()) && HttpMethod.POST.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestDocument) {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry registryEntry = this.getRegistryEntry(jsonPath);
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        Resource resourceBody = this.getRequestBody(requestDocument, jsonPath, HttpMethod.POST);
        PathIds resourceIds = jsonPath.getIds();
        RegistryEntry bodyRegistryEntry = resourceRegistry.getEntry(resourceBody.getType());
        Serializable castedResourceId = this.getResourceId(resourceIds, registryEntry);
        ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(jsonPath.getElementName());
        FieldResourcePost.verifyFieldNotNull(relationshipField, jsonPath.getElementName());
        RegistryEntry relationshipRegistryEntry = resourceRegistry.getEntry(relationshipField.getOppositeResourceType());
        ResourceRepositoryAdapter resourceRepository = relationshipRegistryEntry.getResourceRepository(parameterProvider);
        String relationshipResourceType = relationshipField.getOppositeResourceType();
        this.verifyTypes(HttpMethod.POST, relationshipRegistryEntry, bodyRegistryEntry);
        DocumentMappingConfig mappingConfig = DocumentMappingConfig.create().setParameterProvider(parameterProvider);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        QueryContext queryContext = queryAdapter.getQueryContext();
        Object newResource = this.buildNewResource(relationshipRegistryEntry, resourceBody, relationshipResourceType);
        this.setAttributes(resourceBody, newResource, relationshipRegistryEntry.getResourceInformation(), queryContext);
        Result createdResource = this.setRelationsAsync(newResource, bodyRegistryEntry, resourceBody, queryAdapter, parameterProvider, false).merge(it -> resourceRepository.create(newResource, queryAdapter));
        Result<Result> createdDocument = createdResource.merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, mappingConfig));
        Result<JsonApiResponse> parentResource = registryEntry.getResourceRepository(parameterProvider).findOne(castedResourceId, queryAdapter);
        return createdDocument.zipWith(parentResource, (created, parent) -> this.attachToParent((JsonApiResponse)parent, registryEntry, relationshipField, (Document)created, parameterProvider, queryAdapter)).merge(it -> it).map(this::toResponse);
    }

    public Response toResponse(Document document) {
        return new Response(document, 201);
    }

    private Result<Document> attachToParent(JsonApiResponse parent, RegistryEntry endpointRegistryEntry, ResourceField relationshipField, Document createdDocument, RepositoryMethodParameterProvider parameterProvider, QueryAdapter queryAdapter) {
        Result<JsonApiResponse> result;
        ResourceIdentifier resourceId1 = createdDocument.getSingleData().get();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = endpointRegistryEntry.getRelationshipRepository(relationshipField, parameterProvider);
        Class<?> baseRelationshipFieldClass = relationshipField.getType();
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry relationshipRegistryEntry = resourceRegistry.getEntry(relationshipField.getOppositeResourceType());
        List<ResourceModificationFilter> modificationFilters = this.context.getModificationFilters();
        if (Iterable.class.isAssignableFrom(baseRelationshipFieldClass)) {
            List<ResourceIdentifier> resourceIdList = Collections.singletonList(resourceId1);
            for (ResourceModificationFilter filter : modificationFilters) {
                resourceIdList = filter.modifyManyRelationship(parent.getEntity(), relationshipField, ResourceRelationshipModificationType.ADD, resourceIdList);
            }
            ArrayList<Serializable> parsedIds = new ArrayList<Serializable>();
            for (ResourceIdentifier resourceId : resourceIdList) {
                parsedIds.add(relationshipRegistryEntry.getResourceInformation().parseIdString(resourceId.getId()));
            }
            result = relationshipRepositoryForClass.addRelations(parent.getEntity(), parsedIds, relationshipField, queryAdapter);
        } else {
            for (ResourceModificationFilter filter : modificationFilters) {
                resourceId1 = filter.modifyOneRelationship(parent.getEntity(), relationshipField, resourceId1);
            }
            Serializable parseId = relationshipRegistryEntry.getResourceInformation().parseIdString(resourceId1.getId());
            result = relationshipRepositoryForClass.setRelation(parent.getEntity(), parseId, relationshipField, queryAdapter);
        }
        return result.map(it -> createdDocument);
    }

    private Serializable getResourceId(PathIds resourceIds, RegistryEntry registryEntry) {
        String resourceId = resourceIds.getIds().get(0);
        Class<?> idClass = registryEntry.getResourceInformation().getIdField().getType();
        TypeParser typeParser = this.context.getTypeParser();
        return (Serializable)typeParser.parse(resourceId, idClass);
    }
}

