/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.exception;

import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.internal.exception.CrnkExceptionMapper;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.exception.ExceptionMapperType;
import io.crnk.core.engine.internal.exception.TimeoutExceptionMapper;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.legacy.internal.DefaultExceptionMapperLookup;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public final class ExceptionMapperRegistryBuilder {
    private final Set<ExceptionMapperType> exceptionMappers = new HashSet<ExceptionMapperType>();

    public ExceptionMapperRegistry build(String resourceSearchPackage) {
        return this.build(new DefaultExceptionMapperLookup(resourceSearchPackage));
    }

    public ExceptionMapperRegistry build(ExceptionMapperLookup exceptionMapperLookup) {
        this.addDefaultMappers();
        for (JsonApiExceptionMapper exceptionMapper : exceptionMapperLookup.getExceptionMappers()) {
            this.registerExceptionMapper(exceptionMapper);
        }
        return new ExceptionMapperRegistry(this.exceptionMappers);
    }

    private void addDefaultMappers() {
        this.registerExceptionMapper(new CrnkExceptionMapper());
        this.registerExceptionMapper(new TimeoutExceptionMapper());
    }

    private void registerExceptionMapper(JsonApiExceptionMapper<? extends Throwable> exceptionMapper) {
        Class<?> mapperClass = exceptionMapper.getClass();
        Class<? extends Throwable> exceptionClass = this.getGenericType(mapperClass);
        if (exceptionClass == null && this.isProxy(mapperClass)) {
            mapperClass = mapperClass.getSuperclass();
            exceptionClass = this.getGenericType(mapperClass);
        }
        this.exceptionMappers.add(new ExceptionMapperType(exceptionClass, exceptionMapper));
    }

    private boolean isProxy(Class<? extends JsonApiExceptionMapper> mapperClass) {
        return mapperClass.getName().contains("$$") && JsonApiExceptionMapper.class.isAssignableFrom(mapperClass.getSuperclass());
    }

    private Class<? extends Throwable> getGenericType(Class<? extends JsonApiExceptionMapper> mapper) {
        Type[] types = mapper.getGenericInterfaces();
        if (null == types || 0 == types.length) {
            types = new Type[]{mapper.getGenericSuperclass()};
        }
        for (Type type : types) {
            Class<?> rawType = ClassUtils.getRawType(type);
            if (!(type instanceof ParameterizedType) || !JsonApiExceptionMapper.class.isAssignableFrom(rawType)) continue;
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (this.isProxy(mapper)) {
            return this.getGenericType(mapper.getSuperclass());
        }
        throw new IllegalStateException("unable to discover exception class for " + mapper.getName());
    }
}

