/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.internal.jackson.ErrorDataDeserializer;
import io.crnk.core.engine.internal.jackson.ErrorDataSerializer;
import io.crnk.core.engine.internal.jackson.LinksInformationSerializer;
import io.crnk.core.module.Module;

public class JacksonModule
implements io.crnk.core.module.Module {
    private static final String JSON_API_JACKSON_MODULE_NAME = "crnk";
    private final ObjectMapper objectMapper;
    private final boolean serializeLinksAsObjects;

    public JacksonModule(ObjectMapper objectMapper, boolean serializeLinksAsObjects) {
        this.objectMapper = objectMapper;
        this.serializeLinksAsObjects = serializeLinksAsObjects;
    }

    @Override
    public String getModuleName() {
        return "jackson";
    }

    @Override
    public void setupModule(Module.ModuleContext context) {
        this.objectMapper.registerModule((Module)JacksonModule.createJacksonModule(this.serializeLinksAsObjects));
    }

    public static SimpleModule createJacksonModule() {
        return JacksonModule.createJacksonModule(false);
    }

    public static SimpleModule createJacksonModule(boolean serializeLinksAsObjects) {
        SimpleModule simpleModule = new SimpleModule(JSON_API_JACKSON_MODULE_NAME, new Version(1, 0, 0, null, null, null));
        simpleModule.addSerializer((JsonSerializer)new ErrorDataSerializer());
        simpleModule.addDeserializer(ErrorData.class, (JsonDeserializer)new ErrorDataDeserializer());
        if (serializeLinksAsObjects) {
            simpleModule.addSerializer((JsonSerializer)new LinksInformationSerializer());
        }
        return simpleModule;
    }
}

