/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.result;

import io.crnk.core.engine.result.ImmediateResult;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.result.ResultFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ImmediateResultFactory
implements ResultFactory {
    private ThreadLocal<Object> threadLocal = new ThreadLocal();

    @Override
    public <T> Result<T> just(T object) {
        if (object == null) {
            throw new IllegalArgumentException("cannot use null");
        }
        return new ImmediateResult<T>(object);
    }

    @Override
    public <T> Result<List<T>> zip(List<Result<T>> results) {
        ArrayList<T> list = new ArrayList<T>();
        for (Result<T> result : results) {
            list.add(result.get());
        }
        return new ImmediateResult<List<T>>(list);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public Object getThreadContext() {
        return Objects.requireNonNull(this.threadLocal.get());
    }

    @Override
    public Result<Object> getContext() {
        return new ImmediateResult<Object>(this.getThreadContext());
    }

    @Override
    public void setThreadContext(Object context) {
        this.threadLocal.set(context);
    }

    @Override
    public void clearContext() {
        this.threadLocal.remove();
    }

    @Override
    public boolean hasThreadContext() {
        return this.threadLocal.get() != null;
    }

    @Override
    public <T> Result<T> attachContext(Result<T> result, Object context) {
        return result;
    }
}

